<?php if(count($recommendedProjects) > 0): ?>

    <!-- feature-style-two -->

    <section class="feature-style-two pt-50 pb-50">

        <div class="container">

            <div class="sec-title">

                <h5><?php echo e(trans('home.recommended')); ?></h5>

                <h2><?php echo e(trans('home.recommended_projects')); ?></h2>

            </div>

            <div class="three-item-carousel owl-carousel owl-theme owl-dots-none nav-style-one">

                <?php $__currentLoopData = $recommendedProjects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="feature-block-one">

                        <div class="inner-box">

                            <div class="image-box">

                                <figure class="image">

                                    <div class="img-div lazy-div">

                                        <img class="lazy" data-src="<?php echo e(Helper::uploadedImagesPath('projects',$project->image)); ?>" data-srcset="<?php echo e(Helper::uploadedImagesPath('projects',$project->image)); ?>"alt="<?php echo e($project->alt_img); ?>">

                                        <div class="next-lazy-img"></div>

                                    </div>

                                </figure>

                                <a href="javascript:;">

                                    <span class="category"><?php echo e((app()->getLocale() == 'en')?$project->category->name_en:$project->category->name_en); ?></span>

                                </a>

                            </div>

                            <div class="lower-content">

                                <div class="title-text">

                                    <h4>

                                        <a href="<?php echo e((app()->getLocale() == 'en')? LaravelLocalization::localizeUrl('project/'.$project->link_en) : LaravelLocalization::localizeUrl('project/'.$project->link_ar)); ?>">

                                            <?php echo e((app()->getLocale() == 'en') ? strip_tags(mb_strimwidth($project->name_en, 0, 30, "...")): strip_tags(mb_strimwidth($project->name_ar, 0, 30, "..."))); ?>



                                        </a>

                                    </h4>

                                </div>

                                <div class="price-box clearfix">

                                    <div class="price-info pull-left">

                                        <h6><?php echo e(trans('home.price_range')); ?></h6>

                                        <h4><?php echo e($project->price); ?> <?php echo e(trans('home.LE')); ?></h4>

                                    </div>

                                    <ul class="other-option pull-right clearfix">

                                        <li><a href="<?php echo e((app()->getLocale() == 'en')? LaravelLocalization::localizeUrl('project/'.$project->link_en) : LaravelLocalization::localizeUrl('project/'.$project->link_ar)); ?>"><i class="icon-12"></i></a></li>

                                    </ul>

                                </div>

                                <p class=""><?php echo (app()->getLocale() == 'en') ? strip_tags(mb_strimwidth($project->text_en, 0, 100, "...")): strip_tags(mb_strimwidth($project->text_ar, 0, 100, "...")); ?></p>

                                <ul class="more-details clearfix">

                                    <?php if(count($project->attributes()) > 0): ?>

                                        <?php $__currentLoopData = $project->attributes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <li>

                                                <img src="<?php echo e(Helper::uploadedImagesPath('attribute',$attribute->icon)); ?>" alt ="icon image"/>

                                                <?php $__currentLoopData = $attribute->projectAttributeValues($project->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                    <?php echo e(($lang == 'en')?$value->value_en:$value->value_ar); ?>



                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php echo e(($lang =='en')?$attribute->name_en:$attribute->name_ar); ?>



                                            </li>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php endif; ?>

                                </ul>

                                <!--<div class="btn-box"><a href="<?php echo e((app()->getLocale() == 'en')? LaravelLocalization::localizeUrl('project/'.$project->link_en) : LaravelLocalization::localizeUrl('project/'.$project->link_ar)); ?>" class="theme-btn btn-two">See Details</a></div>-->

                            </div>

                        </div>

                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <div class="more-btn centred"><a href="<?php echo e(LaravelLocalization::localizeUrl('recommended/projects')); ?>" class="theme-btn btn-one"><?php echo e(trans('home.View All Listing')); ?></a></div>

        </div>

    </section>

    <!-- feature-style-two end -->

<?php endif; ?>



<?php /**PATH C:\OSPanel\domains\haliem_company_profile\resources\views/website/home-partials/recommended_projects.blade.php ENDPATH**/ ?>