<!doctype html>
<html class="no-js" lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'ltr'): ?> dir="ltr" <?php else: ?> dir="rtl" <?php endif; ?>>
<head>

    <!-- Meta -->
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="robots" content="noindex, follow">
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <?php echo $__env->yieldContent('title'); ?>
    <!-- Page Title -->
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(url('uploads/settings/source/' . $configration->fav_icon)); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=El+Messiri:wght@400..700&display=swap"
        rel="stylesheet">
    <!--=============== css  ===============-->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('fontawesome.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('flaticon.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('pbminfotech-base-icons.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('themify-icons.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('aos.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('shortcode.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('base.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(Helper::vendorFilesPath('rs6.css')); ?>" />


    
</head>

<body>
    <div class="page-wrapper">
        
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="page-content">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <?php echo $__env->make('layouts.partials.social', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    



    <!-- JS here -->
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
	<script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('numinate.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('aos.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('ScrollTrigger.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('SplitText.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('cursor.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('magnetic.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('gsap-animation.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('scripts.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('rslider.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('rbtools.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::vendorFilesPath('rs6.min.js')); ?>"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {
                // Your custom options
            });
      </script>
    <?php echo $__env->yieldContent('script'); ?>

    <!--Design By Yousef & Dev By Ahmed Essam-->

</body>

</html>
<?php /**PATH C:\OSPanel\domains\elhanager\resources\views/layouts/app.blade.php ENDPATH**/ ?>