@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.addsubheader') }}</title>
@endsection
@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">{{ trans('home.subheader') }}</h4>

                    <div class="page-title-right">
                        <ol class="breadcrumb m-0">
                            <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                            <li class="breadcrumb-item"><a
                                    href="{{ url('/admin/subheaders') }}">{{ trans('home.subheader') }}</a></li>
                            <li class="breadcrumb-item active">{{ trans('home.addsubheader') }}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ trans('home.addsubheader') }}</h4>
                    </div>

                    <div class="card-body p-4">
                        <div class="row">
                            <div class="col-lg-12">
                                <form action="{{ route('subheaders.store') }}" method="POST" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-3 mb-3">
                                            <label>{{ trans('home.title_en') }}</label>
                                            <input type="text" name="title_en" class="form-control"
                                                placeholder="{{ trans('home.title_en') }}" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label>{{ trans('home.title_ar') }}</label>
                                            <input type="text" name="title_ar" class="form-control"
                                                placeholder="{{ trans('home.title_ar') }}" required>
                                        </div>
                                        <div class="col-md-3 mb-3">
                                            <label class="">{{ trans('home.order') }}</label>
                                            <input type="number" name="order" class="form-control"
                                                placeholder="{{ trans('home.order') }}">
                                        </div>
                                        <div class="form-group col-md-6 ">
                                            <label for="text_en">{{ trans('home.text_en') }}</label>
                                            <textarea name="text_en" class="form-control ckeditor-classic" placeholder="{{ trans('home.text_en') }}"></textarea>
                                        </div>
                                        <div class="form-group col-md-6 ">
                                            <label for="text_ar">{{ trans('home.text_ar') }}</label>
                                            <textarea name="text_ar" class="form-control ckeditor-classic" placeholder="{{ trans('home.text_ar') }}"></textarea>
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for="type">{{ trans('home.type') }}</label>
                                            <select name="type" class="form-control" data-trigger required>
                                                <option value="about">{{ trans('home.about-us') }}</option>
                                                <option value="services">{{ trans('home.services') }}</option>
                                                <option value="gallery">{{ trans('home.gallery') }}</option>
                                                <option value="contact">{{ trans('home.contact-us') }}</option>
                                                <option value="blogs">{{ trans('home.blogs') }}</option>
                                                <option value="reviews">{{ trans('home.reviews') }}</option>
                                                <option value="whyus">{{ trans('home.whyus') }}</option>
                                                <option value="teams">{{ trans('home.teams') }}</option>
                                                <option value="projects">{{ trans('home.projects') }}</option>
                                                <option value="awards">{{ trans('home.awards') }}</option>
                                                <option value="brands">{{ trans('home.brands') }}</option>
                                            </select>
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="">{{ trans('home.number') }}</label>
                                            <input type="number" name="number" class="form-control"
                                                placeholder="{{ trans('home.number') }}">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label for="formFile" class="form-label">{{ __('home.choose_image') }}</label>
                                            <input type="file" name="image" placeholder="{{ __('home.chooseImage') }}"
                                                class="form-control" id="formFile">
                                        </div>
                                        <div class="form-group">
                                            <div class="form-check d-flex">
                                                <input type="checkbox" name="status" value="1" id="switch"
                                                    switch="success" checked />
                                                <label for="switch" data-on-label="{{ trans('home.yes') }}"
                                                    data-off-label="{{ trans('home.no') }}"></label>
                                                <label class="form-check-label mx-3"
                                                    for="switch">{{ trans('home.publish') }}</label>
                                            </div>
                                        </div>
                                        <div class="mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-md">{{ __('home.save') }}</button>
                                            <a href="{{ url('/admin/subheaders') }}"><button type="button"
                                                    class="btn btn-danger mr-1">Cancel</button></a>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
