@extends('layouts.admin')
@section('meta')
<title>{{ trans('home.add_team') }}</title>
@endsection
@section('content')
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.teams') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/teams') }}">{{ trans('home.teams') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.add_team') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.add_team') }}</h6>
                        </div>
                        {!! Form::open(['route' => 'teams.store', 'data-toggle' => 'validator', 'files' => 'true']) !!}
                        <div class="row">

                            <div class="form-group col-md-6">
                                <label class="">{{ trans('home.name_en') }}</label>
                                <input class="form-control" name="name_en" type="text"
                                    placeholder="{{ trans('home.name_en') }}" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ trans('home.name_ar') }}</label>
                                <input class="form-control" name="name_ar" type="text"
                                    placeholder="{{ trans('home.name_ar') }}" required>
                            </div>

                            {{-- <div class="form-group col-md-3">
                                <label for="helperText">{{ trans('home.lang') }}</label>
                                <select class="form-control select2" name="lang" required>
                                    <option value="en">{{ trans('home.english') }}</option>
                                    <option value="ar">{{ trans('home.arabic') }}</option>
                                </select>
                            </div> --}}

                            <div class="form-group col-md-6 mb-3">
                                <label class="">{{ trans('home.text_en') }}</label>
                                <input class="form-control ckeditor-classic" name="text_en" type="text"
                                    placeholder="{{ trans('home.text_en') }}">
                            </div>

                            <div class="form-group col-md-6 mb-3">
                                <label class="">{{ trans('home.text_ar') }}</label>
                                <input class="form-control ckeditor-classic" name="text_ar" type="text"
                                    placeholder="{{ trans('home.text_ar') }}">
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">{{ trans('home.position_en') }}</label>
                                <input class="form-control" name="position_en" type="text"
                                    placeholder="{{ trans('home.position_en') }}">
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{ trans('home.position_ar') }}</label>
                                <input class="form-control" name="position_ar" type="text"
                                    placeholder="{{ trans('home.position_ar') }}">
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{ trans('home.experience') }}</label>
                                <input class="form-control" name="experience" type="text"
                                    placeholder="{{ trans('home.experience') }}">
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{ trans('home.email') }}</label>
                                <input class="form-control" name="email" type="text"
                                    placeholder="{{ trans('home.email') }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ trans('home.link') }}</label>
                                <input class="form-control" name="link" type="text"
                                    placeholder="{{ trans('home.link') }}">
                            </div>


                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.mobile') }}</label>
                                <input class="form-control" name="mobile" type="text"
                                    placeholder="{{ trans('home.mobile') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.facebook') }}</label>
                                <input class="form-control" name="facebook" type="text"
                                    placeholder="{{ trans('home.facebook') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.instagram') }}</label>
                                <input class="form-control" name="instgram" type="text"
                                    placeholder="{{ trans('home.instagram') }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.linkedin') }}</label>
                                <input class="form-control" name="linkedin" type="text"
                                    placeholder="{{ trans('home.linkedin') }}">
                            </div>
                          
                            <div class="col-md-8 mb-3 mt-3">
                                        <label for="formFile" class="form-label">{{ trans('home.choose_image') }}</label>
                                        <input class="form-control" type="file" id="formFile" name="img">
                                    </div>
                           <div class="form-group">
                                <div class="form-check d-flex">
                                    <input type="checkbox" value="1" name="status" id="switch" switch="success" />
                                    <label for="switch" data-on-label="{{trans('home.yes')}}" data-off-label="{{trans('home.no')}}"></label>
                                    <label class="form-check-label mx-3" for="switch"> {{trans('home.publish')}}</label>
                                </div>
                            </div>
                            <div class="row">
                                <h6>{{__('home.schedule')}}</h6>
                                @foreach (['monday', 'tuesday', 'wednesday', 'thursday', 'friday','saturday', 'sunday'] as $day)
                                    <div class="form-group col-md-6">
                                        <label class="">{{ ucfirst($day) }} Start Time</label>
                                        <input class="form-control" name="schedule[{{ $day }}][start]"
                                            type="time" placeholder="Start Time">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="">{{ ucfirst($day) }} End Time</label>
                                        <input class="form-control" name="schedule[{{ $day }}][end]"
                                            type="time" placeholder="End Time">
                                    </div>
                                @endforeach
                            </div>
                            
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ trans('home.save') }} </button>
                                <a href="{{ url('/admin/teams') }}"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ trans('home.cancel') }}</button></a>
                            </div>

                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
