<!-- End Navbar Area -->
<header class="main-header">
    <nav class="main-menu">
        <div class="main-menu__wrapper">
            <div class="container">
                <div class="main-menu__wrapper-inner">
                    <div class="main-menu__logo">

                        <a href="{{ LaravelLocalization::localizeUrl('/') }}"><img
                                src="{{ asset('uploads/settings/source/' . $configration->app_logo) }}"
                                alt=""></a>
                    </div>
                    <div class="main-menu__top">
                        <div class="main-menu__top-inner">
                            <ul class="list-unstyled main-menu__contact-list">
                                <li>
                                    <div class="icon">
                                        <i class="icon-telephone"></i>
                                    </div>
                                    @foreach ($phones as $index => $phone)
                                        @if ($index < 1)
                                            <div class="text">
                                                <p><a
                                                        href="tel:{{ $phone->code }}{{ $phone->phone }}">{{ $phone->phone }}</a>
                                                </p>
                                            </div>
                                        @endif
                                    @endforeach
                                </li>
                                <li>
                                    <div class="icon">
                                        <i class="icon-envelope-2"></i>
                                    </div>
                                    <div class="text">
                                        <p><a href="mailto:{{ $setting->email }}">{{ $setting->email }}</a>
                                        </p>
                                    </div>
                                </li>
                            </ul>
                            <div class="main-menu__top-right">
                                <div class="main-menu__top-time">
                                    <div class="main-menu__top-time-icon">
                                        <span class="icon-pin"></span>
                                    </div>
                                    @foreach ($addresses as $index => $address)
                                        @if ($index == 0)
                                            <a href="{{ $address->map_url }}" target="_blank">
                                                <p class="main-menu__top-text">{{ $address->{'title_' . $lang} }}</p>
                                            </a>
                                        @endif
                                    @endforeach
                                </div>
                                <div class="main-menu__social">
                                    @if ($setting->youtube)
                                        <a href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a>
                                    @endif
                                    @if ($setting->facebook)
                                        <a href="{{ $setting->facebook }}"><i class="fab fa-facebook"></i></a>
                                    @endif
                                    @if ($setting->whatsapp)
                                        <a href="https://wa.me/+2{{ $setting->whatsapp }}"><i class="fab fa-whatsapp"></i></a>
                                    @endif
                                    @if ($setting->instgram)
                                        <a href="{{ $setting->instgram }}"><i class="fab fa-instagram"></i></a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="main-menu__bottom">
                        <div class="main-menu__main-menu-box">
                            <a href="#" class="mobile-nav__toggler"><i class="fa fa-bars"></i></a>
                            <ul class="main-menu__list">
                                @foreach ($menus as $menu)
                                    @switch($menu->type)
                                        @case('home')
                                            <li><a
                                                    href="{{ LaravelLocalization::localizeUrl('/') }}">{{ $menu->{'name_' . $lang} }}</a>
                                            </li>
                                        @break

                                        @case('services')
                                            <li class="dropdown">
                                                <a
                                                    href="{{ LaravelLocalization::localizeUrl('services') }}">{{ $menu->{'name_' . $lang} }}</a>
                                                @if (isset($menuServices))
                                                    <ul>
                                                        @foreach ($menuServices as $header_service)
                                                            <li><a
                                                                    href="{{ LaravelLocalization::localizeUrl('service/' . $header_service->{'link_' . $lang}) }}">{{ $header_service->{'name_' . $lang} }}</a>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endif
                                            </li>
                                        @break

                                        @case('main-item')
                                            <li class="dropdown">
                                                <a href="#">{{ $menu->{'name_' . $lang} }}</a>
                                                @if (!empty($menu->subMenu()) && count($menu->subMenu()) > 0)
                                                    <ul>
                                                        @foreach ($menu->subMenu() as $submenu)
                                                            <li><a
                                                                    href="{{ LaravelLocalization::localizeUrl($submenu->type) }}">{{ $submenu->{'name_' . $lang} }}</a>
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endif
                                            </li>
                                        @break

                                        @default
                                            <li>
                                                <a
                                                    href="{{ LaravelLocalization::localizeUrl($menu->type) }}">{{ $menu->{'name_' . $lang} }}</a>
                                            </li>
                                    @endswitch
                                @endforeach
                            </ul>
                        </div>
                      {{--  <div class="main-menu__search-and-btn-box">
                            <div class="main-menu__btn-box">
                                @foreach (LaravelLocalization::getSupportedLocales() as $localeCode => $properties)
                                    @if ($localeCode != LaravelLocalization::getCurrentLocale())
                                        <a href="{{ LaravelLocalization::getLocalizedURL($localeCode, null, [], true) }}"
                                            class="thm-btn main-menu__btn">
                                            {{ __("home.$localeCode") }}<span class="icon-up-right-arrow"></span>
                                        </a>
                                    @endif
                                @endforeach
                            </div>
                        </div>--}}

                    </div>
                </div>
            </div>
        </div>
    </nav>
</header>
<div class="stricky-header stricked-menu main-menu">
    <div class="sticky-header__content"></div><!-- /.sticky-header__content -->
</div><!-- /.stricky-header -->
