 <!-- info area start -->
 <div class="extra-info">
     <div class="close-icon">
         <button>
             <i class="far fa-window-close"></i>
         </button>
     </div>
     <div class="logo-side mb-30">
         <a href="{{ LaravelLocalization::localizeUrl('/') }}">
             <img src="{{ asset('uploads/settings/source/' . $configration->app_logo) }}" alt="">
         </a>
     </div>
     <div class="side-info mb-30">
         <div class="contact-list mb-30">
             <h4>Clinc Address</h4>
             @foreach ($addresses as $index => $address)
                 @if ($index == 0)
                     <a href="{{ $address->map_url }}" target="_blank">
                         <p>{{ $address->{'title_' . $lang} }}</p>
                     </a>
                 @endif
             @endforeach
         </div>
         <div class="contact-list mb-30">
             <h4>Phone Number</h4>
             @foreach ($phones as $index => $phone)
                 @if ($index == 0)
                     <p><a href="tel:{{ $phone->code }}{{ $phone->phone }}" target="_blank">{{ $phone->phone }}</a></p>
                 @endif
             @endforeach
         </div>
         <div class="contact-list mb-30">
             <h4>Email Address</h4>
             {{-- <p><a href="" class="__cf_email__"
                     data-cfemail="86efe8e0e9c6e3fee7ebf6eae3a8e5e9eb">[email&#160;protected]</a></p> --}}
             <p><a href="mailto:{{ $setting->email }}" class="__cf_email__" data-cfemail="{{ $setting->email }}"
                     target="_blank">{{ $setting->email }}</a></p>
         </div>
     </div>

     <div class="social-icon-right mt-20">
         @if ($setting->facebook)
             <a href="{{ $setting->facebook }}" target="_blank"><i class="fab fa-facebook-f"></i></a>
         @endif
         @if ($setting->twitter)
             <a href="{{ $setting->twitter }}" target="_blank"><i class="fab fa-twitter"></i></a>
         @endif
         @if ($setting->instgram)
             <a href="{{ $setting->instgram }}" target="_blank"><i class="fab fa-instagram"></i></a>
         @endif
         @if ($setting->tiktok)
             <a href="{{ $setting->tiktok }}" target="_blank"><i class="fab fa-tiktok"></i></a>
         @endif
     </div>
 </div>
 <div class="offcanvas"></div>
 <!-- info area end -->
 <!-- responsive menu start -->
 <div class="mobile-nav">
     <div>
         <button class="mobile-nav-close text-white">
             <i class="fal fa-times"></i>
         </button>
     </div>
     <nav>
         <div class="nav" id="nav-tab" role="tablist">
             <a class="nav-link active" id="menu-tab-1-tab" data-bs-toggle="tab" href="#menu-tab-1" role="tab"
                 aria-selected="true">Menu</a>
             <a class="nav-link" id="menu-tab-2-tab" data-bs-toggle="tab" href="#menu-tab-2" role="tab"
                 aria-selected="false">Info</a>
         </div>
     </nav>
     <div class="responsive-logo">
         <a href="{{ LaravelLocalization::localizeUrl('/') }}"><img
                 src="{{ asset('uploads/settings/source/' . $configration->app_logo) }}" alt=""></a>
     </div>
     <div class="tab-content" id="nav-tabContent">
         <div class="tab-pane fade show active" id="menu-tab-1" role="tabpanel">
             <div class="mobile-menu"></div>
         </div>
         <div class="tab-pane fade" id="menu-tab-2" role="tabpanel">
             <div class="side-info mb-30">
                 <div class="contact-list mb-30">
                     <h4>Office Address</h4>
                     @foreach ($addresses as $index => $address)
                         @if ($index == 0)
                             <a href="{{ $address->map_url }}" target="_blank">
                                 <p>{{ $address->{'title_' . $lang} }}</p>
                             </a>
                         @endif
                     @endforeach
                 </div>
                 <div class="contact-list mb-30">
                     <h4>Phone Number</h4>
                     @foreach ($phones as $index => $phone)
                         @if ($index < 2)
                         <a href="tel:{{ $phone->code }}{{ $phone->phone }}"><p>{{ $phone->phone }}</p></a>
                         @endif
                     @endforeach
                 </div>
                 <div class="contact-list mb-30">
                     <h4>Email Address</h4>
                     <p><a href="{{$setting->email}}" class="__cf_email__"
                             data-cfemail="3d54535b527d58455c504d5158135e5250" target="_blank">{{$setting->email}}</a></p>
                 </div>
             </div>
         </div>
     </div>
 </div>
 <!-- responsive menu end -->
