<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('title', 'Dr Dyno'); ?>
    <title>Dr Dyno</title>
    <?php echo $__env->yieldContent('meta'); ?>

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&display=swap" rel="stylesheet">

    <link rel="shortcut icon" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>"
        type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>" type="image/x-icon">
    <!-- Stylesheets -->
    <link href="<?php echo e(Helper::cssFilesPath('bootstrap.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" rel="stylesheet">
    <!-- <link href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>" rel="stylesheet"> -->
    <!-- Responsive File -->
    <link href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>" rel="stylesheet">
    <!-- Responsive -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
    <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
        <link href="<?php echo e(Helper::cssFilesPath('rtl.css')); ?>" rel="stylesheet">
    <?php endif; ?>
</head>

<body>
    <!-- ========= Prealoader ==============-->
    <div id='wrapper' class="page-wrapper rtl">

        <div class="loader-wrap">
            <div class="layer layer-one"><span class="overlay"></span></div>
            <div class="layer layer-two"><span class="overlay"></span></div>
            <div class="layer layer-three"><span class="overlay"></span></div>
        </div>
        <!--========= End Prealoader ============== -->
        <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <main>
            <?php echo $__env->yieldContent('content'); ?>
        </main>
        <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <ul class="wrapper">
        <li class="icon call">
            <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($index == 0): ?>
                    <span><a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><i class="fa fa-phone"></i></a></span>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </li>
        <li class="icon whatsapp">
            <?php if($setting->whatsapp): ?>
                <span><a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target="_blank"><i class="fa fa-facebook"></i></a></span>
            <?php endif; ?>
        </li>
    </ul>
    <!--Scroll to top-->
<div class="scroll-to-top">
    <div>
        <div class="scroll-top-inner">
            <div class="scroll-bar">
                <div class="bar-inner"></div>
            </div>
            <div class="scroll-bar-text"> <i class="fal fa-arrow-left"></i> </div>

        </div>
    </div>
</div>
<!-- Scroll to top end -->
    
    <!--Social Media-->
    
    <!--Social Media-->
    <!-- Start Go Top Section -->
    
    <!-- End Back to Top -->
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('appear.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('TweenMax.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.ajaxchimp.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('parallax-scroll.js')); ?>"></script>

    <script src="<?php echo e(Helper::jsFilesPath('script.js')); ?>"></script>

    <script>
        let currentSection = 0;
        const sections = document.querySelectorAll('section');

        document.addEventListener('wheel', function(event) {
            // إلغاء التأثير الافتراضي للتمرير
            event.preventDefault();

            if (event.deltaY > 0) { // التمرير لأسفل
                currentSection++;
                if (currentSection < sections.length) {
                    sections[currentSection].scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            } else { // التمرير لأعلى
                currentSection--;
                if (currentSection >= 0) {
                    sections[currentSection].scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            }
        }, {
            passive: false
        }); // يجب أن نستخدم { passive: false } لتمكين `preventDefault()`
    </script>

    <script>
        var swiper = new Swiper(".mySwiper", {
            direction: "vertical",
            slidesPerView: 1,
            spaceBetween: 1,
            mousewheel: true,
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            on: {
                slideChangeTransitionEnd: function() {
                    if (swiper.isEnd) {
                        //   swiper.destroy();
                        document.body.style.overflow = "auto";
                    } else {
                        document.body.style.overflow = "hidden";
                    }
                }
            }
        });
    </script>

    
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\drdyno\resources\views/layouts/app.blade.php ENDPATH**/ ?>