<!DOCTYPE html>
<html lang="zxx">
   <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <?php echo $__env->yieldContent('title', 'Iris'); ?>
        <title>Archex. Architecture + Interior Design</title>
        <?php echo $__env->yieldContent('meta'); ?>
        <link rel="shortcut icon" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>" />
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('plugins.css')); ?>" />
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>" />
        
    </head>
<body>
    <!-- Preloader -->
    <div class="preloader-bg"></div>
    <div id="preloader">
        <div id="preloader-status">
            <div class="preloader-position loader"> <span></span> </div>
        </div>
    </div>
     <!-- Progress scroll totop -->
     <div class="progress-wrap cursor-pointer">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>

    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Start Go Top Section -->
    <ul class="wrapper">
        <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($index == 0): ?>
                <li class="icon call">
                    <span><a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><i class="fa fa-phone"></i></a></span>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($setting->whatsapp): ?>
            <li class="icon whatsapp">
                <span><a href="https://wa.me/<?php echo e($setting->whatsapp); ?>" target="_blank"><i class="fab fa-whatsapp"
                            aria-hidden="true"></i></a></span>
            </li>
        <?php endif; ?>
    </ul>
    <!-- Back to Top -->
    <button type="button" id="back-to-top" class="position-fixed text-center border-0 p-0">
        <i data-feather="chevron-up"></i>
    </button>
    <!-- End Back to Top -->
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <!-- jQuery -->
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery-migrate-3.4.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('modernizr-2.6.2.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.isotope.v3.0.2.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('popper.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('scrollIt.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.waypoints.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.stellar.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('YouTubePopUp.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('vegas.slider.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('custom.js')); ?>"></script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\albadr\resources\views/layouts/app.blade.php ENDPATH**/ ?>