
<title><?php echo e(trans('home.homeImages')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.homeImages')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.homeImages')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>


        <?php $__currentLoopData = $homeImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $homeImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <!-- Row-->
            <div class="row">
                <div class="col-sm-12 col-xl-12 col-lg-12">
                    <div class="card custom-card overflow-hidden">
        
                        <div class="card-body">
                            <div>
                                <h6 class="card-title mb-1"><?php echo e(trans('home.edit_image')); ?> <?php echo e($homeImage->id); ?></h6>
                            </div>
                            <?php echo Form::open(['method'=>'PATCH','url' => 'admin/home-images/'.$homeImage->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                    <div class="col-md-4">
                                        <label><?php echo e(trans('home.image_en')); ?></label>
                                        <div class="input-group mb-1">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                            </div>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="img_en">
                                                <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_img_en')); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <label><?php echo e(trans('home.image_ar')); ?></label>
                                        <div class="input-group mb-1">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                            </div>
                                            <div class="custom-file">
                                                <input type="file" class="custom-file-input" name="img_ar">
                                                <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_img_ar')); ?></label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-lg-4">
                                        <label><?php echo e(trans('home.link')); ?></label>
                                        <div class="input-group mb-3">
                                            <input aria-describedby="basic-addon2" name="link" class="form-control"  type="text" value="<?php echo e($homeImage->link); ?>">
                                            <div class="input-group-append">
                                                <span class="input-group-text" id="basic-addon2"><?php echo e(trans('home.link')); ?></span>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if($homeImage->img_en): ?>
                                        <div class="col-md-4">
                                            <img src="<?php echo e(url('\uploads\homeImages\resize200')); ?>\<?php echo e($homeImage->img_en); ?>" width="150">
                                        </div>
                                    <?php endif; ?>

                                    <?php if($homeImage->img_ar): ?>
                                        <div class="col-md-4">
                                            <img src="<?php echo e(url('\uploads\homeImages\resize200')); ?>\<?php echo e($homeImage->img_ar); ?>" width="150">
                                        </div>
                                    <?php endif; ?>
            
                                    <div class="form-group col-md-12">
                                        <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.update')); ?> </button>
                                    </div>
                                    
                                </div>
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
            <!-- End Row -->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\Almashreq\resources\views/admin/homeImages/homeImages.blade.php ENDPATH**/ ?>