<!DOCTYPE html>
<html lang="zxx">

 <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <?php echo $__env->yieldContent('title', 'Iris'); ?>
        <title>iris dental</title>
        <?php echo $__env->yieldContent('meta'); ?>
        <!-- Link of CSS Files -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link
            href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=El+Messiri:wght@400..700&display=swap"
            rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.min.css')); ?>">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.css" />
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('swiper-bundle.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('flaticon_doral.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('scrollCue.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('responsive.css')); ?>">
        <link rel="icon" type="image/png" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>">
        <!-- Stylertl CSS -->
        <?php if(LaravelLocalization::getCurrentLocaleDirection() == 'rtl'): ?>
            <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('stylertl.css')); ?>">
        <?php endif; ?>
    </head>

<body>
    <!-- Start Preloader Area -->
    <div class="preloader-area text-center position-fixed top-0 bottom-0 start-0 end-0" id="preloader">
        <div class="loader position-absolute start-0 end-0">
            <img src="<?php echo e(asset('uploads/settings/source/' . $configration->fav_icon)); ?>" alt="favicon">
            <div class="waviy position-relative">
                <span class="d-inline-block">I</span>
                <span class="d-inline-block">R</span>
                <span class="d-inline-block">I</span>
                <span class="d-inline-block">S</span>
                <span class="d-inline-block">_</span>
                <span class="d-inline-block">D</span>
                <span class="d-inline-block">E</span>
                <span class="d-inline-block">N</span>
                <span class="d-inline-block">T</span>
                <span class="d-inline-block">A</span>
                <span class="d-inline-block">L</span>
            </div>
        </div>
    </div>
    <!-- End Preloader Area -->

    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Start Go Top Section -->
    <ul class="wrapper">
        <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($index == 0): ?>
                <li class="icon call">
                    <span><a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>"><i class="fa fa-phone"></i></a></span>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($setting->whatsapp): ?>
            <li class="icon whatsapp">
                <span><a href="https://wa.me/<?php echo e($setting->whatsapp); ?>" target="_blank"><i class="fab fa-whatsapp"
                            aria-hidden="true"></i></a></span>
            </li>
        <?php endif; ?>
    </ul>
    <!-- Back to Top -->
    <button type="button" id="back-to-top" class="position-fixed text-center border-0 p-0">
        <i data-feather="chevron-up"></i>
    </button>
    <!-- End Back to Top -->
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <!-- Link of JS Files -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script data-cfasync="false" src="/cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('swiper-bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('feather.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('fslightbox.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('scrollCue.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('simpleParallax.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/@fancyapps/ui@5.0/dist/fancybox/fancybox.umd.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
    <script>
        Fancybox.bind("[data-fancybox]", {});
    </script>
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\iris\resources\views/layouts/app.blade.php ENDPATH**/ ?>