<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">


<head>
    <!-- meta tags -->
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- title -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('title', 'Wafco'); ?>
    <title>Wafco</title>
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('uploads/settings/source/' . $configration->app_logo)); ?>">

    <!-- css -->
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('all-fontawesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('magnific-popup.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('nice-select.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(Helper::cssFilesPath('style.css')); ?>">
    
</head>

<body>
    <!-- ========= Prealoader ==============-->
    <!-- preloader -->
    <div class="preloader">
        <div class="loader-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <!-- preloader end -->
    <!--========= End Prealoader ============== -->
    <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>
    <?php echo $__env->make('layouts.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- scroll-top -->
    <a href="#" id="scroll-top"><i class="far fa-arrow-up"></i></a>
    <!-- scroll-top end -->

    <ul id=" " class="social-sec " style="transform: translate(15%, 100%); ">
        <li class="Icon call ">
            <!--<span class="tooltip ">Call</span>-->
            <?php $__currentLoopData = $phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($index == 0): ?>
                    <a href="tel:<?php echo e($phone->code); ?><?php echo e($phone->phone); ?>" target="_blank "><i
                            class="fa fa-phone "></i></a>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </li>
        <?php if($setting->whatsapp): ?>
            <li class="Icon whatsapp ">
                <!--<span class="tooltip ">Whatsapp</span>-->
                <a href="https://wa.me/+2<?php echo e($setting->whatsapp); ?>" target="_blank "><i class="fab fa-whatsapp"></i></a>
            </li>
        <?php endif; ?>
    </ul>
    
    <!--Social Media-->
    
    <!--Social Media-->
    <!-- Start Go Top Section -->
    
    <!-- End Back to Top -->
    <!-- End Go Top Section -->
    <!--scrollup-->
    
    

    <!-- JS ============================================ -->
    <script data-cfasync="false" src="../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('modernizr.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('imagesloaded.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.magnific-popup.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('isotope.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.appear.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.easing.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('owl.carousel.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('counter-up.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('jquery.nice-select.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('wow.min.js')); ?>"></script>
    <script src="<?php echo e(Helper::jsFilesPath('main.js')); ?>"></script>
    
    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\OSPanel\domains\wafco\resources\views/layouts/app.blade.php ENDPATH**/ ?>