<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_slider')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"><?php echo e(trans('home.home_sliders')); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/admin/home-sliders')); ?>"><?php echo e(trans('home.home_sliders')); ?></a></li>
                        <li class="breadcrumb-item active"><?php echo e(trans('home.edit_slider')); ?></li>
                    </ol>
                </div>

            </div>
        </div>
    </div>


    <!-- Row-->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title"><?php echo e(trans('home.edit_slider')); ?></h4>
                </div>
                <div class="card-body p-4">
                    <div class="row">
                        <div class="col-lg-12">
                            <?php echo Form::open(['method'=>'PATCH','url' => 'admin/home-sliders/'.$slider->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                                <!-- Row-->
                                <div class="row">

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.title_en')); ?></label>
                                        <input class="form-control" name="title_en" type="text" placeholder="<?php echo e(trans('home.title_en')); ?>" value="<?php echo e($slider->title_en); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.title_ar')); ?></label>
                                        <input class="form-control" name="title_ar" type="text" placeholder="<?php echo e(trans('home.title_ar')); ?>" value="<?php echo e($slider->title_ar); ?>">
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.text_en')); ?></label>
                                        <textarea class="form-control ckeditor-classic" id="ckeditor-classic" name="text_en"  placeholder="<?php echo e(trans('home.text_en')); ?>"><?php echo $slider->text_en; ?></textarea>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.text_ar')); ?></label>
                                        <textarea class="form-control ckeditor-classic" id="ckeditor-classic" name="text_ar"  placeholder="<?php echo e(trans('home.text_ar')); ?>"><?php echo $slider->text_ar; ?></textarea>
                                    </div>


                                    

                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.link')); ?></label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">http://www.google.com</span>
                                            </div>
                                            <input type="text" class="form-control" name="link" placeholder="<?php echo e(trans('home.link')); ?>"  value="<?php echo e($slider->link); ?>">
                                        </div>
                                    </div>


                                    <div class="col-md-6 mb-3">
                                        <label class=""><?php echo e(trans('home.order')); ?></label>
                                        <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="<?php echo e(trans('home.order')); ?>" value="<?php echo e($slider->order); ?>" required>
                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <label for="formFile" class="form-label"><?php echo e(trans('home.choose_image')); ?></label>
                                        <input class="form-control" type="file" id="formFile" name="image">
                                    </div>

                                    <?php if($slider->image): ?>
                                        <div class="form-group  col-md-3">
                                            <img src="<?php echo e(url('\uploads\sliders\home-sliders\source')); ?>\<?php echo e($slider->image); ?>" width="350" height="150">
                                        </div>
                                    <?php else: ?>
                                        <div class="form-group  col-md-3">
                                            <img src="<?php echo e(url('resources/assets/back/images/noimage.jpg')); ?>" width="70">
                                        </div>
                                    <?php endif; ?>

                                </div>
                                <div class="form-group">
                                    <div class="form-check d-flex">
                                        <input type="checkbox" value="1" name="status" id="switch" switch="success" <?php echo e(($slider->status == 1)? 'checked':''); ?>  />
                                        <label for="switch" data-on-label="<?php echo e(trans('home.yes')); ?>" data-off-label="<?php echo e(trans('home.no')); ?>"></label>
                                        <label class="form-check-label mx-3" for="switch"> <?php echo e(trans('home.publish')); ?></label>
                                    </div>
                                </div>
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary w-md"><?php echo e(trans('home.save')); ?></button>
                                    <a href="<?php echo e(url('/admin/home-sliders')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                <!-- End Row -->
                            <?php echo Form::close(); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\OSPanel\domains\drdyno\resources\views/admin/sliders/home-sliders/editSlider.blade.php ENDPATH**/ ?>