<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\ContactUs;
use Exception;

class ContactusController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:contact-us']);
    }

    public function index()
    {
        $contactUsMessages = ContactUs::orderBy('id','DESC')->get();
        return view('admin.contactUsMessages.contactUsMessages',compact('contactUsMessages'));
    }







    public function show($id)
    {
        $contactUsMessage = ContactUs::find($id);
        if($contactUsMessage){
            $contactUsMessage->seen = 1;
            $contactUsMessage->save();
            return view('admin.contactUsMessages.contactUsMessage_details',compact('contactUsMessage'));
        }else{
            abort('404');
        }
    }






    public function destroy($id)
    {

        try {
            if( request('id')){
                $ids =  request('id') ;
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:contact_us,id'
                ]);
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                ContactUs::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($contactUs = ContactUs::find($id)){
                $contactUs->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json( Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }

}
