<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\RegionRequest;
use App\Models\Region;
use App\Models\Country;
use Exception;
use Illuminate\Http\Request;

class RegionController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:regions']);
    }

    public function index()
    {
        //
        $regions = Region::orderBy('id','DESC')->with(['country'])->get();
        return view('admin.regions.regions',compact('regions'));
    }


    public function create()
    {
        //
        $countries = Country::where('status',1)->get();
        return view('admin.regions.addRegion',compact('countries'));
    }

    public function store(Request $request)
    {
        $data = $request->validated() ;
        if(Region::create($data)){
            return redirect()->back()->with('success',trans('home.your_item_added_successfully'));
        }
        return redirect()->back()->withErrors(trans('home.an error has occurred. Please contact the developer to resolve the issue'));
    }



    public function edit($id)
    {
        //
        $region=Region::find($id);
        $countries = Country::where('status',1)->get();
        return view('admin.regions.editRegion',compact('region','countries'));
    }


    public function update(RegionRequest $request, $id)
    {
        $region = Region::find($id);
        $data = $request->validated() ;
        if($region->update($data)){
            return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
        }
        return redirect()->back()->withErrors(trans('home.an error has occurred. Please contact the developer to resolve the issue'));
    }


    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:regions,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Region::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($region = Region::find($id)){
                $region->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json(Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}


