<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Testimonial;
use App\Helpers\Helper;


use DB;
use File;
use Image;

class TestimonialController extends Controller
{
    public function __construct()
    {
        $this->middleware('permission:testimonial');
    }
    

    public function index()
    {
        $testimonials = Testimonial::get();
        return view('admin.testimonials.index',compact('testimonials'));
    }


    public function create()
    {
        return view('admin.testimonials.create');
    }


    public function store(TestimonialRequest $request)
    {
        $data = $request->validated();
        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path( $data['image'],true);
            $fileName = $saveImage->saveImages('testimonials');
            $data['image'] = $fileName;
        }
         
       Testimonial::create($data) ;
        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }



    public function edit($id)
    {
        //
        $testimonial = Testimonial::find($id);
        if($testimonial){
            return view('admin.testimonials.edit',compact('testimonial'));
        }else{
            abort('404');
        }
        
    }


    public function update(TestimonialRequest $request, $id)
    {
        $testimonial = Testimonial::find($id);
        $data = $request->validated();
        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path( $data['image'],true);
            $fileName = $saveImage->saveImages('testimonials');
            SaveImageTo3Path::deleteImage($testimonial->image,'testimonials');
            $data['image'] = $fileName;
        }
       $testimonial->update($data) ;
        return redirect()->back()->with('success',trans('home.your_item_updated_successfully'));
    }


   
    
    public function destroy($id)
    {

        try {
            if( request('id')){
                request()->validate([
                    'id' => 'array|min:1|',
                    'id.*' => 'exists:testimonials,id'
                ]);
                $ids =  request('id') ;
                $ids = is_array(   $ids ) ?    $ids  : [ $ids ];
                Testimonial::whereIn('id',$ids)->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_items_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_items_deleted_successfully'));
            }elseif($testimonial = Testimonial::find($id)){
                $testimonial->delete();
                if(request()->ajax()){
                    return response()->json(['message'=>trans('home.your_item_deleted_successfully')]);
                }
                return redirect()->back()->with('success',trans('home.your_item_deleted_successfully'));
            }
            return redirect()->back()->withErrors(trans('home.not_found'));
        } catch (Exception $ex) {
            if(request()->ajax()){
                return response()->json(Helper::messageError( trans('home.Unable to delete this item because it has related items'))->errors(),422);
            }
            return redirect()->back()->withErrors(trans('home.Unable to delete this item because it has related items'));
        }

    }
}
