<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Product;
use App\Traits\SeoTrait;

class BrandController extends Controller
{

    use SeoTrait;

    public function show($brand_link)
    {
        $data['brand'] = Brand::active()->where('link_ar',$brand_link)
        ->orWhere('link_en' ,$brand_link)->first();
        if(!$data['brand']){
            return abort(404);
        }
        $data['categoriesFilter'] = Category::active()->whereHas('products' )->get();
        $data['inStock'] = Product::active()->whereHas('brand',function($q) use($brand_link){
            $q->where('link_ar',$brand_link)
            ->orWhere('link_en' ,$brand_link);
        })->hasStock()->filterProduct()->whereHas('stocks', function($q){
            $q->where('stock', '>', 0);
        })->count();
        $data['outOfStock'] = Product::active()->whereHas('brand',function($q) use($brand_link){
            $q->where('link_ar',$brand_link)
            ->orWhere('link_en' ,$brand_link);
        })->hasStock()->filterProduct()->whereHas('stocks', function($q){
            $q->where('stock', '=', 0);
        })->count();
        $data['all'] = Product::active()->whereHas('brand',function($q) use($brand_link){
            $q->where('link_ar',$brand_link)
            ->orWhere('link_en' ,$brand_link);
        })->hasStock()->filterProduct()->count();
        $data['products'] = Product::active()->whereHas('brand',function($q) use($brand_link){
            $q->where('link_ar',$brand_link)
            ->orWhere('link_en' ,$brand_link);
        })->hasStock()->filterProduct()->paginate(50)->appends(request()->query());;
        list($data['schema'], $data['metatags']) = $this->productSPageSeo();

        return view('website.products.index',$data);
    }
    
    public function index()
    {
        $data['brands'] = Brand::active()->get();

        list($data['schema'], $data['metatags']) = $this->brandsPageSeo();

        return view('website.brands.index',$data);
    }

}
