<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\CartItemRequest;
use App\Models\Coupon;
use App\Models\Page;
use App\Models\Product;
use App\Traits\Carts\CartTrait;


class CartController extends Controller
{
    use CartTrait ;

    public function sidebar(){

        $data['cart'] = $this->getCartBasedAuth() ; // get cart if auth or guist
        if (request()->ajax()) {
            $data['count'] =  $data['cart']->items->count();
            $data['cart'] = view('website.componants.cart-in-sidebar', $data)->render() ;
            return response()->json($data) ;
        }
        return view('web.carts.index' ,$data ) ;
    }
    public function index(){

        $data['cart'] = $this->getCartBasedAuth() ; // get cart if auth or guist
        $data['terms'] = Page::find(1) ;
        $data['shipping'] = Page::find(2) ;
        $data['mayLikeProducts'] = Product::whereIn('category_id' , $data['cart']->items->pluck('product_category_id')->toArray())->get() ;
        return view('website.carts.index' ,$data ) ;
    }

    public function addItem(CartItemRequest $request){
        $Item = $request->validated() ;
        if($this->saveItemOrUpdateToCart( $Item)){
            if(request()->ajax()){
                return response()->json(['message'=> __('home.Product Added To Cart'),'wrong_messages' => session('errors',[])]);
            }
           return redirect()->back()->with('success' , __('home.Product Added To Cart'));
        }

        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred') ,'wrong_messages' => session('errors',[])],500);
        }
        return redirect()->back()->withErrors( __('home.an error occurred'));
    }

    public function updateItem(CartItemRequest $request){
        $Item = $request->validated() ;
        if($this->updateInCart( $Item)){
            if(request()->ajax()){
                return response()->json(['message'=> __('home.Product Added To Cart'), 'wrong_messages' => session('errors',[])]);
            }
           return redirect()->back()->with('success' , __('home.Product Added To Cart'));
        }


        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred'), 'wrong_messages' => session('errors',[])],500);
        }
        return redirect()->back()->withErrors( __('home.an error occurred'));
    }


    public function addCoupon(){

        $cart = $this->getCartBasedAuth() ; // get cart if auth or guist
        $coupon = Coupon::where('code', request('coupon_code'))->first();
        if($coupon){
            $cart->update(['coupon_id' => $coupon->id]) ;
            $cart->refresh() ;
            if($coupon->canUse( $cart->total_price)){
                return redirect()->back()->with('success',__('home.Coupon used Successfully !'));
            }
            $cart->update(['coupon_id' => null]) ;
            return redirect()->back();
        }
        return redirect()->back()->withErrors(__('home.Sorry Coupon Not Found'));

    }

    public function destroyItem( $stock_id){
        if($this->deleteItemFromCart($stock_id)){
           if(request()->ajax()){
            return response()->json(['message'=> __('home.your_item_deleted_successfully'),'wrong_messages' =>  session('errors',[])]);
           }
           return redirect()->back()->with('message' , __('home.your_item_deleted_successfully'));
        }

        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred'), 'wrong_messages' => session('errors',[])]);
           }
           return redirect()->back()->withErrors( __('home.an error occurred'));
    }



}
