<?php

namespace App\Http\Controllers\Website;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\CouponRequest;
use App\Models\Coupon;
use App\Models\CouponBrand;
use App\Models\CouponProduct;
use App\Models\CouponUser;
use App\Models\CouponCategory;
use App\Models\CouponRegion;
use App\Models\CouponShipping;
use App\Models\Region;
use App\Models\Category;
use App\Models\Product;
use App\Models\Brand;
use App\Models\User;


class CouponController extends Controller
{

    public function index()
    {
        //
        $coupons = Coupon::get();
        return view('admin.coupons.coupons',compact('coupons'));
    }

    public function create()
    {
        return view('admin.coupons.addCoupon');
    }


    public function store(CouponRequest $request)
    {
        $request_validated = $request->validated();
        $new_coupon = Coupon::create($request_validated);
        
        return redirect()->route('coupons.index')->with('success',trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {
        $coupon = Coupon::find($id);
        if($coupon){
            
            return view('admin.coupons.editCoupon',compact('coupon'));
    
        }else{
            abort('404');
        }
    }


    public function update(CouponRequest $request, $id)
    {
        $request_validated = $request->validated();
        $coupon = Coupon::find($id);
        $coupon->update($request_validated);

        ///////// remove old selectd values ////

       
        return redirect()->route('coupons.index')->with('success',trans('home.your_item_updated_successfully'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * 
     */
    public function destroy($ids)
    {
        $ids = explode(',', $ids);
        if ($ids[0] == 'on') {
            unset($ids[0]);
        }
        foreach ($ids as $id) {
            Coupon::findOrFail($id)->delete();
        }
    }


    public function couponType(){
        $type=$_POST['type'];

        $categories=Category::where('status',1)->get();
        $brands=Brand::where('status',1)->get();
        $products=Product::where('status',1)->get();
        $users=User::where('status','active')->get();
        $regions=Region::where('status',1)->get();
        return response()->json([
            'html' => view('admin.coupons.couponTypes', compact('type','categories','brands','users','regions','products'))->render(),
        ]);

    }

}
