<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Http\Requests\WishlistRequest;
use App\Models\User;
use App\Models\Wishlist;

class WishlistController extends Controller
{
    public function __construct(){
        $this->middleware('auth') ;
    }
    public function index(){
        $data['wishlists'] = Wishlist::where('user_id' , auth() ->user()->id) ->with('productStock')->get();
        return view('website.wishlist.index' , $data  ) ;
    }

    public function store(WishlistRequest $request){
        $Item = $request->validated() ;
        $user = User::find(auth()->user()->id) ;
        if( $user->wishlistItems()->create($Item)){
            if(request()->ajax()){
                return response()->json(['message'=> __('home.your_item_added_successfully')]);
            }
           return redirect()->back()->with('success' , __('home.your_item_added_successfully'));
        }

        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred')],500);
        }
        return redirect()->back()->withErrors( __('home.an error occurred'));
    }

    public function getCount(){
        $user = User::find(auth()->user()->id) ;
        if(request()->ajax()){
            return response()->json(['count'=> $user->wishlistItems->count()]);
        }
        return redirect()->back()->with('success' , $user->wishlistItems->count());
    }



    public function destroyItem( $stock_id){
        $user = User::find(auth()->user()->id) ;
        if($user->wishlistItems()->where('product_stock_id',$stock_id)->delete()){
           if(request()->ajax()){
            return response()->json(['message'=> __('home.your_item_deleted_successfully')]);
           }
           return redirect()->back()->with('message' , __('home.your_item_deleted_successfully'));
        }

        if(request()->ajax()){
            return response()->json(['message'=> __('home.an error occurred')]);
           }
           return redirect()->back()->withErrors( __('home.an error occurred'));
    }



}
