<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title_ar' => 'required|string|max:255|unique:pages,title_ar,' .$this->route('page'),
            'title_en' => 'required|string|max:255|unique:pages,title_en,'.$this->route('page'),
            'text_ar' => 'required|string',
            'text_en' => 'required|string',
            'link_ar' => 'required|string|max:255|unique:pages,link_ar,'.$this->route('page'),
            'link_en' => 'required|string|max:255|unique:pages,link_en,'.$this->route('page'),
            'mete_title_ar' => 'nullable|string|max:255',
            'mete_title_en' => 'nullable|string|max:255',
            'mete_description_ar' => 'nullable|string',
            'mete_description_en' => 'nullable|string',
            'status' => 'nullable|string|max:255',
            'show_in_product_details' => 'nullable|in:0,1',
            'index' => 'nullable|boolean',
        ];
    }
}
