<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Announcement extends Model
{
    use HasFactory;

    private $lang ;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }
    protected $fillable = [
        'title_en',
        'title_ar',
        'status',
    ];

    public function getTitleAttribute(){
        return $this->{'title_'.$this->lang};
    }


    public function getStatusTextAttribute(){
        return $this->status ? __("home.yes") : __("home.no");
    }

    public function scopeActive($query){
        return $query->whereStatus(1) ;
    }


}
