<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;


class Area extends Model
{
    //
	protected $table='areas';

    private $lang ;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function region(){
        return $this->belongsTo('App\Models\Region','region_id');
    }

    public function addresses(){
        return $this->hasMany('App\Models\Address','area_id');
    }


    public function getNameAttribute(){
        return $this->{'name_'.$this->lang};
    }


    public function scopeByRegion($query ,$region_id){
        return $query->where('region_id', $region_id);
    }

    public function scopeByRegionAuth($query){
        return $query->where('region_id', auth()->user()?->primary_address?->region_id);
    }

}
