<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Branch extends Model
{
    use HasFactory;

    protected $fillable = [
        'name_ar',
        'name_en',
        'address_ar',
        'address_en',
        'map_url',
        'status',
        'order',
        'email' ,

    ];

    private $lang ;
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        // Set the current locale dynamically
        $this->lang = Helper::getLang();

    }

    public function getNameAttribute(){
        return $this->{'name_'.$this->lang};
    }

    public function getAddressAttribute(){
        return $this->{'address_'.$this->lang};
    }
    public function getActiveAttribute(){
        $this->status ? __('home.yes') : __( 'home.no') ;
    }

    public function phones(){
        return $this->morphMany(Phone::class,'phonable');
    }

    public function scopeActive($query){
        return $query->whereStatus(1);
      }

    public function scopeUnactive($query){
        return $query->whereStatus(0);
    }
}
