<?php
namespace App\Traits\Carts;


use Illuminate\Support\Facades\DB;


trait CartTrait {

    use GuestCartTrait ,AuthCartTrait ;
    private function getCartBasedAuth():object{

        if(auth()->check()){
            return  $this->getCart() ;
        }else{
            return $this->getGuestCart() ;
        }
    }


    private function saveItemOrUpdateToCart(array $item):bool{
        if($cart = $this->getCartBasedAuth()){
            $cart->items()->updateOrCreate(
                [ 'product_stock_id' => $item['product_stock_id'] ] ,
                [
                    'quantity' => DB::raw('quantity + ' . $item['quantity'])
                ]
            );
            $cart->can_use_coupon;
             return true ;
        }
        return false;

     }

     private function updateInCart(array $item):bool{
        if($cart = $this->getCartBasedAuth()){
            $cart->items()->updateOrCreate(
                [ 'product_stock_id' => $item['product_stock_id'] ] ,
                [
                    'quantity' =>   $item['quantity']
                ]
            );
            $cart->can_use_coupon;
             return true ;
        }
        return false;

     }



     private function deleteItemFromCart(int $stock_id): bool
     {
        if ($cart = $this->getCartBasedAuth()) {
            $item = $cart->items()->where('product_stock_id' , $stock_id);
            if ($item) {
                $item->delete();
                $cart->refresh() ;
                $cart->can_use_coupon;
                return true;
            }
        }
        return false;
     }


}