<?php

namespace App\Traits;

use App\Helpers\Helper;
use App\Models\User;
use App\Traits\Carts\CartTrait;
use Illuminate\Support\Facades\Hash;

trait OrderTrait
{

    use CartTrait ;

    function CheckProduct(): array
    {
        $cart = $this->getCart();
        $items_status = true;
        if($cart ->coupon && !$cart->can_use_coupon){
            Helper::messageError( __('home.an error occurred'));
            $items_status = false ;
            return [$items_status , $cart ]; // Return invalid items
        }
        if(!$cart  || empty($cart->items->toArray())){
            Helper::messageError( __('home.please select at least oneproduct to checkout'));
            $items_status = false ;
            return [$items_status , $cart ]; // Return invalid items
        }
        foreach ($cart->items as &$item) {
            if ($item->quantity > ($item->productStock?->stock ?? 0)) {
                Helper::messageError( $item->product_name
                . ' ' .__('home.has available stock:')
                . ' ' . $item->productStock?->stock
                . ' ' .__('home.your order:')
                . ' ' .$item->quantity );
                $items_status = false ;
            }else{
                $item->price = $item->product_price ;
                $item->total = $item->item_total_price ;
                $item->discount_id = $item->product_discount_id  ;
                $item->product_discount = $item->product_discount_amount  ;
                unset($item->cart_id) ;
            }
        }

        return [$items_status , $cart ]; // Return invalid items
    }

}
