<?php

namespace App\Traits;

use App\Models\ShippingFees;
use Exception;

trait ShippingTrait
{

    private function getShipping($area_id = null)
    {
        $shipping = 0 ;
        switch (config('site_shipping_status')) {
            case 'doesnt_use':
                $shipping = 0;
                break;

            case 'free':
                $shipping = 0;
                break;

            case 'by_place':
                $shipping =  $this->getShippingByPlace($area_id)  ;
                break;
            case 'one_cost':
                $shipping = config('site_shipping_fees');
                break;
        }

        return  $shipping  ;
    }

    private function getShippingByPlaceForAuth(){
        $address = auth()?->user()?->PrimaryAddress ;
        if(!$address){
            return  config('site_shipping_fees') ;
        }

        $shippingFee = ShippingFees::where('area_id', $address->area_id)->value('fees');
        return $shippingFee && $shippingFee > 0 ?$shippingFee :config('site_shipping_fees');
    }
    private function getShippingByPlace($area_id = 0){
        if(!$area_id && auth()->check()){
            $address = auth()?->user()?->PrimaryAddress ;
            if($address){
                $area_id =  $address ->area_id  ;
            }else{
                $area_id =   request('area_id') ;
            }
        }
        $shippingFee = ShippingFees::where('area_id', $area_id)->value('fees') ;

        return $shippingFee && $shippingFee > 0 ?$shippingFee :config('site_shipping_fees');
    }
}
