@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.branches')}}</title>
@endsection
@section('content')
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.branches')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.branches')}}</li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a href="{{url('admin/branches/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i> {{trans('home.publish/unpublish')}}</button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
        </div>
        <!-- End Page Header -->
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.branches')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>
                                        <th><input type="checkbox" id="checkAll"/></th>
                                        <th>{{trans('home.id')}}</th>
                                        <th>{{trans('home.name')}}</th>
                                        <th>{{trans('home.address')}}</th>
                                        <th>{{trans('home.phones')}}</th>
                                        <th>{{trans('home.status')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($branches as $branch)
                                        <tr id="{{$branch->id}}">
                                            <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$branch->id}}" /> </td>
                                            <td><a href="{{ route('branches.edit', $branch->id) }}">{{$branch->id}}</a></td>
                                            <td><a href="{{ route('branches.edit', $branch->id) }}">{{$branch->name}}</a></td>
                                            <td>
                                                <a href="{{ route('branches.edit', $branch->id) }}">
                                                    {{$branch->address}}
                                                </a>
                                            </td>
                                            <td>
                                                <a href="{{LaravelLocalization::localizeUrl('admin/branches/'.$branch->id.'/get-phones') }}" class="status btn btn-info"><i class="fas fa-phone"></i>@if($branch->phones->isEmpty()) {{trans('home.doesn\'t have')}} / {{trans('home.add')}} @else   {{trans('home.show')}} {{$branch->phones->count()}} @endif</a>
                                            </td>
                                            <td>
                                                <a href="{{ route('branches.edit', $branch->id) }}" class="status">@if($branch->status == 1) {{trans('home.yes')}} @else  {{trans('home.no')}} @endif</a>
                                            </td>
                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
					    </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
