@extends('layouts.admin')
<title>{{trans('home.coupons')}}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.coupons')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.coupons')}}</li>
                </ol>
            </div>

            <div class="btn btn-list">
                <a href="{{url('admin/coupons/create')}}"><button class="btn ripple btn-primary"><i class="fas fa-plus-circle"></i> {{trans('home.add')}}</button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><i class="fas fa-trash"></i> {{trans('home.delete')}}</button></a>
            </div>
        </div>
        <!-- End Page Header -->


        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">

                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.coupons')}}</h6>
                            <p class="text-muted card-sub-title">{{trans('home.table_contain_all_data_shortly_you_can_view_more_details')}}</p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th>{{trans('home.id')}}</th>
                                    <th>{{trans('home.name')}}</th>
                                    <th>{{trans('home.expire_date')}}</th>
                                    <th>{{trans('home.value')}}</th>
                                    <th>{{trans('home.value_type')}}</th>
                                    <th>{{trans('home.coupon_type')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($coupons as $coupon)
                                    <tr id="{{$coupon->id}}">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="{{$coupon->id}}" /> </td>
                                        <td><a href="{{ route('admin.coupons.edit', $coupon->id) }}">{{$coupon->id}}</a></td>
                                        <td><a href="{{ route('admin.coupons.edit', $coupon->id) }}">{{$coupon->name}}</a></td>
                                        <td><a href="{{ route('admin.coupons.edit', $coupon->id) }}">{{$coupon->end_date}}</a></td>
                                        <td><a href="{{ route('admin.coupons.edit', $coupon->id) }}">{{$coupon->discount}}</a></td>
                                        <td><a href="{{ route('admin.coupons.edit', $coupon->id) }}">{{$coupon->discount_type_text}}</a></td>
                                        <td><a href="{{ route('admin.coupons.edit', $coupon->id) }}"> {{trans("home.$coupon->type")}} </a></td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
					</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
