@extends('layouts.admin')
<title>{{trans('home.edit_testimonials')}}</title>
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.testimonials')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/testimonials')}}">{{trans('home.testimonials')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_testimonial')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_testimonial')}}</h6>
                        </div>
                        {!! Form::open(['method'=>'PATCH','url' => 'admin/testimonials/'.$testimonial->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                            <div class="row">

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.name_en')}}</label>
                                    <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}" value="{{$testimonial->name_en}}">
                                </div> <div class="form-group col-md-6">
                                    <label class="">{{trans('home.name_ar')}}</label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{$testimonial->name_ar}}">
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.position')}}</label>
                                    <input class="form-control" name="position" type="text" placeholder="{{trans('home.position')}}" value="{{$testimonial->position}}">
                                </div>
                                
                                <div class="form-group  col-md-6">
                                    <label>{{trans('home.image')}}</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> {{trans('home.upload')}}</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                        </div>
                                    </div>
                                </div>
                                
                            

                                
                                <div class="form-group  col-md-12">
                                    <img src="{{ $testimonial->image_200 }}" width="200" height="150">                                    </div>
                                </div>
                              

                                <div class="form-group col-md-12">
                                    <label class="">{{trans('home.text_en')}}</label>
                                    <textarea class="form-control" name="text_en"  placeholder="{{trans('home.text_en')}}">{!! $testimonial->text_en !!}</textarea>
                                </div>
                                <div class="form-group col-md-12">
                                    <label class="">{{trans('home.text_ar')}}</label>
                                    <textarea class="form-control" name="text_ar"  placeholder="{{trans('home.text_ar')}}">{!! $testimonial->text_ar !!}</textarea>
                                </div>
                                <br>

                                <div class="form-group col-md-4">
                                    <label class="ckbox">
                                        <input name="status" value="1" {{($testimonial->status == 1)? 'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{url('/admin/testimonials')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                                
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
