@extends('layouts.admin')
@section('meta')
<title>{{trans('home.edit')}} {{trans('home.vendor')}}</title>
@endsection
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.vendors')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/vendors')}}">{{trans('home.vendors')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit')}} {{trans('home.vendor')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit')}} {{trans('home.vendor')}}</h6>
                        </div>
                        {!! Form::open(['method'=>'PATCH','url' => 'admin/vendors/'.$vendor->id, 'data-toggle'=>'validator', 'files'=>'true']) !!}
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.name_en')}}</label>
                                <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}"  value="{{$vendor->name_en}}" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.name_ar')}}</label>
                                <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}" value="{{$vendor->name_ar}}" required>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.countries')}}</label>
                                <select class="form-control select2 get-regions" id="country" name="country_id" >
                                    <option value="">@lang('home.country')</option>
                                    @foreach ($countries as $country)
                                        <option @selected($vendor?->country_id  == $country->id ) value="{{$country->id}}">{{$country->name}}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.region')}}</label>
                                <div id="region-container" >
                                    <select class="form-control select2 get-areas" id="region" name="region_id" data-default="">
                                        <option value="">@lang('home.region')</option>
                                        @foreach ($regions as $region)
                                            <option @selected($vendor?->region_id  == $region->id ) value="{{$region->id}}"> {{$region->name}} </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="parent">{{trans('home.areas')}}</label>
                                <div id="area-container" >
                                     <select class="form-control select2" id="area" name="area_id" >
                                        <option value="">@lang('home.area')</option>
                                        @foreach ($areas as $area)
                                            <option @selected($vendor?->area_id == $area->id ) value="{{$area->id}}">{{$area->name}}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.address')}}</label>
                                <input class="form-control" name="address" type="text" placeholder="{{trans('home.address')}}" value="{{$vendor->address}}">
                            </div>
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.phone')}}</label>
                                <input class="form-control" name="phone" type="text" placeholder="{{trans('home.phone')}}" value="{{$vendor->phone}}" >
                            </div>
                            <div class="col-md-12">
                                <label>{{trans('home.logo')}} (225px  * 225px max 1mb)</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="logo">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>
                            <div class="row col-12">
                                <div class="col-md-6">
                                    @if($vendor->logo_200)
                                        <img src="{{$vendor->logo_200}}" width="150">
                                    @endif
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="status" value="1" {{($vendor->status == 1)? 'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                </label>
                            </div>


                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                <a href="{{url('/admin/vendors')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>

                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
@section('script')
@include('website.scripts.checkout.get-regions')
@include('website.scripts.checkout.get-areas')

@endsection