
@extends('layouts.app')
@section('meta')
<title> @lang('home.login')</title>
@endsection
@section('content')
@include('website.banner' ,['bannerTitle' => __('home.login')])

<section class="flat-spacing-10">
    <div class="container">
        <div class="tf-grid-layout lg-col-2 tf-login-wrap">
            <div class="tf-login-form">
                <div id="recover">
                    <h5 class="mb_24">@lang('home.Reset Password')</h5>
                    <p class="mb_30">@lang('home.Send Password Reset Link')</p>
                    <div>
                        <form class="" id="login-form" action="{{ route('password.email') }}" method="post" accept-charset="utf-8" data-mailchimp="true">
                            @csrf
                            <div class="tf-field style-1 mb_15">
                                <input class="tf-field-input tf-input" placeholder="@lang('home.email')" type="email" id="property3" name="email">
                                <label class="tf-field-label fw-4 text_black-2" for="property3">@lang('home.email') *</label>
                            </div>
                            <div class="mb_20">
                                <a href="#login" class="tf-btn btn-line">@lang('home.cancel')</a>
                            </div>
                            <div class="">
                                <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">@lang('home.Reset Password')</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div id="login">
                    <h5 class="mb_36">@lang('home.login')</h5>
                    <div>
                        <form class="" id="login-form" action="{{ route('login') }}" method="post" accept-charset="utf-8">
                            @csrf
                            <div class="tf-field style-1 mb_15">
                                <input class="tf-field-input tf-input" placeholder="@lang('home.email')" type="email" id="property3" @old('email') name="email">
                                <label class="tf-field-label fw-4 text_black-2" for="property3">@lang('home.email') *</label>
                            </div>
                            <div class="tf-field style-1 mb_30">
                                <input class="tf-field-input tf-input" placeholder="" type="password" @old('password') id="property4" name="password">
                                <label class="tf-field-label fw-4 text_black-2" for="property4">@lang('home.password') *</label>
                            </div>
                            <div class="mb_20">
                                <a href="#recover" class="tf-btn btn-line">@lang('home.Forgot your password?')</a>
                            </div>
                            <div class="">
                                <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">@lang('home.login')</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="tf-login-content">
                <h5 class="mb_36">@lang('home.I\'m new here')</h5>
                <p class="mb_20">@lang('home.Sign up for early Sale access plus tailored new arrivals, trends and promotions. To opt out, click unsubscribe in our emails')</p>
                <a href="register.html" class="tf-btn btn-line">@lang('home.register')<i class="icon icon-arrow1-top-left"></i></a>
            </div>
        </div>
    </div>
</section>
@endsection

@section('script')

@endsection
