@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection
@section('content')
    <div class="page-content">
        <!-- blog-detail -->
        @include('website.banner',['bannerTitle' =>  __('home.blogs') ])
        <div class="blog-grid-main">
            <div class="container">
                <div class="row">
                    @foreach ($blogs ?? $blogsHeaders->take(3) as $blog )
                        <div class="col-xl-4 col-md-6 col-12">
                            <div class="blog-article-item">
                                <div class="article-thumb">
                                    <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}">
                                        <img class="lazyload" data-src="{{$blog->image_source}}" src="{{$blog->image_source}}" alt="img-blog">
                                    </a>
                                    <div class="article-label">
                                        <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}" class="tf-btn btn-sm radius-3 btn-fill animate-hover-btn">{{$blog->title}}</a>
                                    </div>
                                </div>
                                <div class="article-content">
                                    <div class="article-title">
                                        <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}" class="">{{Helper::removeTagsAndCutText($about->text,50) }}.</a>
                                    </div>
                                    <div class="article-btn">
                                        <a href="{{LaravelLocalization::localizeUrl('blog/'.$blog->link)}}" class="tf-btn btn-line fw-6">Read more<i class="icon icon-arrow1-top-left"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
@endsection
