@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp

    @php echo $schema @endphp
@endsection
@section('content')


@include('website.banner',['bannerTitle' => __('home.branches') ])


        <!-- Store locations -->
        <section class="flat-spacing-15">
            <div class="container">
                <div class="row widget-tabs">
                    <div class="col-xl-4 col-md-5 col-12">
                        <div class="tf-store-list d-flex gap-10 flex-column widget-menu-tab">
                            @foreach ($branches as $branch )
                                <div class="tf-store-item item-title default {{ $loop->first ? 'active' : ''}}" >
                                    <h6 class="tf-store-title">
                                        <div class="icon">
                                            <i class="icon-place"></i>
                                        </div>
                                        {{$branch->name}}
                                    </h6>
                                    <div class="tf-store-info">
                                        <span>@lang('home.address')</span>
                                        <p> {{$branch->address}}</p>
                                    </div>
                                    <div class="tf-store-info">
                                        <span>@lang('home.email')</span>
                                        <p>{{$branch->email}}</p>
                                    </div>
                                    @foreach ($branch->phones as $phone )
                                        <div class="tf-store-info">
                                            <span>{{$phone->title}}</span>
                                            <p>{{$phone->phone}}</p>
                                        </div>
                                    @endforeach
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="col-xl-8 col-md-7 col-12">
                        <div class="widget-content-tab">
                            @foreach ($branches as $branch )
                                <div class="widget-content-inner active p-0">
                                    <iframe src="{{$branch->map_url}}" width="100%" height="978" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /Store locations -->
@endsection

@section('script')

@endsection
