
@extends('layouts.app')
@section('meta')
<title> @lang('home.shopping_cart')</title>
@endsection
@section('content')
    <!-- page-title -->
    @include('website.carts.banner')
    <!-- /page-title -->
    
    <!-- page-cart -->
    <section class="flat-spacing-11">
        <div class="container">
            {{-- 
                <div class="tf-cart-countdown">
                    <div class="title-left">
                        <svg class="d-inline-block" xmlns="http://www.w3.org/2000/svg" width="16" height="24" viewBox="0 0 16 24" fill="rgb(219 18 21)">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M10.0899 24C11.3119 22.1928 11.4245 20.2409 10.4277 18.1443C10.1505 19.2691 9.64344 19.9518 8.90645 20.1924C9.59084 18.2379 9.01896 16.1263 7.19079 13.8576C7.15133 16.2007 6.58824 17.9076 5.50148 18.9782C4.00436 20.4517 4.02197 22.1146 5.55428 23.9669C-0.806588 20.5819 -1.70399 16.0418 2.86196 10.347C3.14516 11.7228 3.83141 12.5674 4.92082 12.8809C3.73335 7.84186 4.98274 3.54821 8.66895 0C8.6916 7.87426 11.1062 8.57414 14.1592 12.089C17.4554 16.3071 15.5184 21.1748 10.0899 24Z"></path>
                        </svg>
                        <p>These products are limited, checkout within </p>
                    </div>
                    <div class="js-countdown timer-count" data-timer="600" data-labels="d:,h:,m:,s"></div>
                </div> 
            --}}
            @include('website.carts.cart')
        </div>
    </section>
    <!-- page-cart -->
    
    <!-- product -->
    <section class="flat-spacing-17 pt_0">
        <div class="container">
            <div class="flat-title">
                <span class="title">@lang('home.You may also like')</span>
            </div>
            <div class="hover-sw-nav hover-sw-2">
                <div dir="ltr" class="swiper tf-sw-product-sell wrap-sw-over" data-preview="4" data-tablet="3" data-mobile="2" data-space-lg="30" data-space-md="15" data-pagination="2" data-pagination-md="3" data-pagination-lg="3">
                    <div class="swiper-wrapper">
                        @foreach ($mayLikeProducts as $product)
                            <div class="swiper-slide" lazy="true">
                                @include('website.card-product' , ['cartProduct' => $product , 'cartProductId' => 'best-seller-'.$product->link ])
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="nav-sw nav-next-slider nav-next-product box-icon w_46 round"><span class="icon icon-arrow-left"></span></div>
                <div class="nav-sw nav-prev-slider nav-prev-product box-icon w_46 round"><span class="icon icon-arrow-right"></span></div>
                <div class="sw-dots style-2 sw-pagination-product justify-content-center"></div>
            </div>
        </div>
    </section>
    <!-- /product -->

    {{-- <!-- Testimonial -->
    <section class="flat-spacing-17 pt_0 flat-testimonial">
        <div class="container">
            <div class="flat-title">
                <span class="title">Happy Clients</span>
            </div>
            <div class="wrap-carousel">
                <div dir="ltr" class="swiper tf-sw-testimonial" data-preview="3" data-tablet="2" data-mobile="1" data-space-lg="30" data-space-md="15">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="testimonial-item style-column">
                                <div class="rating">
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                </div>
                                <div class="heading">Best Online products Site</div>
                                <div class="text">
                                    “ I always find something New and good Quality on this web bathroom unit site ”
                                </div>
                                <div class="author">
                                    <div class="name">Mohamed Ragab</div>
                                    <div class="metas">Customer from Cairo</div>
                                </div>
                                <div class="product">
                                    <div class="image">
                                        <a href="product-detail.html">
                                            <img class="lazyload" data-src="images/product/11.webp" src="images/product/11.webp" alt="">
                                        </a>
                                    </div>
                                    <div class="content-wrap">
                                        <div class="product-title">
                                            <a href="product-detail.html">Bathroom Unit</a>
                                        </div>
                                        <div class="price">105.95 EGP</div>
                                    </div>
                                    <a href="product-detail.html" class=""><i class="icon-arrow1-top-left"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item style-column">
                                <div class="rating">
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                </div>
                                <div class="heading">Great Selection and Quality</div>
                                <div class="text">
                                    "I always find something New and good Quality on this website"
                                </div>
                                <div class="author">
                                    <div class="name">Ahmed Ibrahim</div>
                                    <div class="metas">Customer from Alexandia</span></div>
                                </div>
                                <div class="product">
                                    <div class="image">
                                        <a href="product-detail.html">
                                            <img class="lazyload" data-src="images/product/31.webp" src="images/product/31.webp" alt="">
                                        </a>
                                    </div>
                                    <div class="content-wrap">
                                        <div class="product-title">
                                            <a href="product-detail.html">floor Ceramic</a>
                                        </div>
                                        <div class="price">70.95 EGP</div>
                                    </div>
                                    <a href="product-detail.html" class=""><i class="icon-arrow1-top-left"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item style-column">
                                <div class="rating">
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                </div>
                                <div class="heading">Best Customer Service</div>
                                <div class="text">
                                    "I finally found a web Bathroom Accessories site with variety and options"
                                </div>
                                <div class="author">
                                    <div class="name">Mostafa Alaa</div>
                                    <div class="metas">Customer from Matroh</div>
                                </div>
                                <div class="product">
                                    <div class="image">
                                        <a href="product-detail.html">
                                            <img class="lazyload" data-src="images/product/6.webp" src="images/product/6.webp" alt="">
                                        </a>
                                    </div>
                                    <div class="content-wrap">
                                        <div class="product-title">
                                            <a href="product-detail.html">Bathtub </a>
                                        </div>
                                        <div class="price">From 185.00 EGP</div>
                                    </div>
                                    <a href="product-detail.html" class=""><i class="icon-arrow1-top-left"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="testimonial-item style-column">
                                <div class="rating">
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                    <i class="icon-star"></i>
                                </div>
                                <div class="heading">Great Selection and Quality</div>
                                <div class="text">
                                    "I love the variety of styles and the high-quality clothing on this web fashion site."
                                </div>
                                <div class="author">
                                    <div class="name">Khaled Medhat</div>
                                    <div class="metas">Customer from Suez</span></div>
                                </div>
                                <div class="product">
                                    <div class="image">
                                        <a href="product-detail.html">
                                            <img class="lazyload" data-src="images/product/8.webp" src="images/product/8.webp" alt="">
                                        </a>
                                    </div>
                                    <div class="content-wrap">
                                        <div class="product-title">
                                            <a href="product-detail.html">Light roasted blended </a>
                                        </div>
                                        <div class="price">165.00 EGP</div>
                                    </div>
                                    <a href="product-detail.html" class=""><i class="icon-arrow1-top-left"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="nav-sw nav-next-slider nav-next-testimonial lg"><span class="icon icon-arrow-left"></span></div>
                <div class="nav-sw nav-prev-slider nav-prev-testimonial lg"><span class="icon icon-arrow-right"></span></div>
                <div class="sw-dots style-2 sw-pagination-testimonial justify-content-center"></div>
            </div>
        </div>
    </section>
    <!-- /Testimonial --> --}}

@endsection

@section('script')

@endsection
            