<div class="tf-mini-cart-main">
    <div class="tf-mini-cart-sroll">
        <div class="tf-mini-cart-items">
            @foreach ($cart?->items ?? [] as $item)
                <div class='tf-mini-cart-item {{"cart-$item->product_link"}} product-item' data-unique-class='{{"cart-$item->product_link"}}'>
                    <div class="tf-mini-cart-image">
                        <a href="{{LaravelLocalization::localizeUrl('product/'.$item->product_link)}}">
                            <img src="{{$item->product_main_image}}" alt="">
                        </a>
                    </div>
                    <div class="tf-mini-cart-info">
                        <a class="title link" href="{{LaravelLocalization::localizeUrl('product/'.$item->product_link)}}"></a>
                        <div class="meta-variant">{{$item->product_name}}</div>
                        <div class="price product-price fw-6">{{$item->product_net_price}}</div>
                        <div class="tf-mini-cart-btns">
                            <div class="wg-quantity small">
                                <!-- we will set quantity when click-->
                                <span data-quantity="{{$item->quantity}}" data-stock_id="{{$item->product_stock_id}}" class="btn-quantity minus-btn">-</span>
                                <input type="text" name="number" class="quantity-input product-quantity"  value="{{$item->quantity}}">
                                 <!-- we will set quantity when click-->
                                <span data-quantity="{{$item->quantity}}" data-stock_id="{{$item->product_stock_id}}" class="btn-quantity plus-btn">+</span>
                            </div>
                            <div  data-stock_id="{{$item->product_stock_id}}" style="cursor: pointer" class="tf-mini-cart-remove">@lang('home.remove')</div>
                        </div>
                    </div>
                </div>
            @endforeach

        </div>
    </div>
</div>
<div class="tf-mini-cart-bottom">
    <div class="tf-mini-cart-bottom-wrap">
        <div class="tf-cart-totals-discounts">
            <div class="tf-cart-total">@lang('home.subtotal')</div>
            <div id="sub-total-price" class="tf-totals-total-value fw-6">{{$cart?->net_total_price}}</div>
        </div>
        <div class="tf-cart-tax"><a href="#">@lang('home.shipping')</a> @lang('home.calculated at checkout') </div>
        <div class="tf-mini-cart-line"></div>
        <div class="tf-mini-cart-view-checkout">
            <a href="{{LaravelLocalization::localizeUrl('carts')}}" class="tf-btn btn-outline radius-3 link w-100 justify-content-center">@lang('home.View Cart')</a>
            <a href="{{LaravelLocalization::localizeUrl('checkout')}}" class="tf-btn btn-fill animate-hover-btn radius-3 w-100 justify-content-center"><span>@lang('home.checkout')</span></a>
        </div>
    </div>
</div>
