<script>
    $(function(){
        $(document).on('change','.get-shipping-fees', function () {
            let area_id = $(this).val() ;

            getShippingFees(area_id ,function(response) {
                if(response.status){

                    const shippingFees = parseFloat(response.shipping_fees) || 0;
                    const currentTotal =   checkShippingFree({{$cart->net_total_price}} ,shippingFees) ;
                    
                    $('.shipping-fees').html(shippingFees)
                    $('.end-total').html(currentTotal)

                }
            })
        })
    })

    function checkShippingFree(total ,shipping){
        if({{config('site_shipping_free_in_status')}}){
            return total > {{config('site_shipping_free_in_amount') ?? 0}}  ? total : total  + shipping ;
        }
        return  total + shipping
    }

    function getShippingFees(area_id ,callback){
        $.ajax({
            url: "{{LaravelLocalization::localizeUrl('orders/get-shipping-fees')}}",
            method: 'GEt',
            data: {'area_id': area_id},
            success: function(response){


                callback({
                    'status': true ,
                    'shipping_fees': response.shipping_fees,
                })

            },
            error: function (xhr, status, error) {
                callback({
                    'status': false ,
                })
                errorMessage(xhr, status, error)
            }

        })
    }
</script>