<script>

    var isRTL = "{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}";
    
    toastr.options = {
        closeButton: true,
        progressBar: true,
        positionClass: 'toast-top-' + (isRTL === 'rtl' ? 'right' : 'left'),
        showDuration: 300,
        hideDuration: 500,
        timeOut: 10000,
        extendedTimeOut: 1000,
        showEasing: 'swing',
        hideEasing: 'linear',
        showMethod: 'fadeIn',
        hideMethod: 'fadeOut',
        rtl: isRTL === 'rtl', // Enable Toastr's RTL mode for Arabic
    
        // Adjust close button after toast is shown
        onShown: function(toast) {
            var closeBtn = $(toast).find('.toast-close-button');
            if (isRTL === 'rtl') {
                closeBtn.css({ 'float': 'left' }); // Move close button to left in RTL mode
            } else {
                closeBtn.css({ 'float': 'right' }); // Move close button to right in LTR mode
            }
        }
    };

    @if ($errors->any())
        @foreach ($errors->all() as $error)
            toastr.error('{{ $error }}');
        @endforeach
    @endif

    @if (session()->has('success'))
        @if (is_array(session('success')))
            @foreach (session('success') as $message)
                toastr.success('{{ $message }}');
            @endforeach
        @else
            toastr.success('{{ session('success') }}');
        @endif
    @endif
    $(document).ready(function() {
        $(document).on('DOMNodeInserted', '.toast', function() {
            var toast = $(this);
    
            // Ensure icons and close button follow RTL
            if (isRTL === 'rtl') {
                toast.addClass('rtl-toast'); // Custom class for styling adjustments
                toast.find('.toast-close-button').css('float', 'left'); // Move close button to left
            } else {
                toast.find('.toast-close-button').css('float', 'right'); // Move close button to right for LTR
            }
        });
    });
</script>