@extends('layouts.app')
@section('meta')
    <title> @lang('home.edit_account_information')</title>
@endsection
@section('content')

@include('website.banner', [
    'bannerTitle' =>__('home.edit_account_information'),
])
        <!-- page-cart -->
        <section class="flat-spacing-11">
            <div class="container">
                <div class="row">
                    @include('website.user.links')

                    <div class="col-lg-9">
                        <div class="my-account-content account-edit">
                            <div class="">
                                <form class="" method="POST"   enctype="multipart/form-data" id="form-password-change" action="{{LaravelLocalization::localizeUrl('dashboard/update-my-account')}}">
                                    @method('patch')
                                    @csrf
                                    <div class="tf-field style-1 mb_15">
                                        <input class="tf-field-input tf-input" type="file" hidden  id="user-imag-inp" name="image"  accept="image/*"  onchange="previewImage(event)" >
                                        <img src="{{$user->image_source}}" alt="User Image"  id="user-image-preview" onclick="document.getElementById('user-imag-inp').click()"  style="cursor: pointer; width: 150px; height: 150px; object-fit: cover; border-radius: 50%;"  >
                                    </div>

                                    <div class="tf-field style-1 mb_15">
                                        <input class="tf-field-input tf-input" type="text" value="{{$user->f_name}}" placeholder="@lang('home.f_name')" type="text" id="property1" name="f_name">
                                        <label class="tf-field-label fw-4 text_black-2"for="property1">@lang('home.f_name')</label>
                                    </div>
                                    <div class="tf-field style-1 mb_15">
                                        <input class="tf-field-input tf-input"  value="{{$user->l_name}}" placeholder="@lang('home.l_name')" type="text" id="property2" name="l_name">
                                        <label class="tf-field-label fw-4 text_black-2" for="property2">@lang('home.l_name')</label>
                                    </div>
                                    <div class="tf-field style-1 mb_15">
                                        <input class="tf-field-input tf-input" value="{{$user->email}}" placeholder="@lang('home.email')" type="email" id="property3" name="email">
                                        <label class="tf-field-label fw-4 text_black-2" for="property3">@lang('home.email')</label>
                                    </div>
                                    <h6 class="mb_20">@lang('home.Password change')</h6>
                                    <div class="tf-field style-1 mb_30">
                                        <input class="tf-field-input tf-input"  placeholder="@lang('home.Current Password')" type="password" id="property4" name="current_password">
                                        <label class="tf-field-label fw-4 text_black-2" for="property4">@lang('home.Current Password')</label>
                                    </div>
                                    <div class="tf-field style-1 mb_30">
                                        <input class="tf-field-input tf-input"   placeholder="@lang('home.new_password')" type="password" id="property5" name="password">
                                        <label class="tf-field-label fw-4 text_black-2" for="property5">@lang('home.new_password')</label>
                                    </div>
                                    <div class="tf-field style-1 mb_30">
                                        <input class="tf-field-input tf-input"   placeholder="@lang('home.Confirm Password')" type="password" id="property6" name="password_confirmation">
                                        <label class="tf-field-label fw-4 text_black-2" for="property6">@lang('home.Confirm Password')</label>
                                    </div>
                                    <div class="mb_20">
                                        <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">@lang('change')</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- page-cart -->
@endsection
@section('script')
<script>
    function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('user-image-preview');

    if (input.files && input.files[0]) {
        const reader = new FileReader();

        reader.onload = function(e) {
            preview.src = e.target.result; // Set the preview image's src to the file's data URL
        };

        reader.readAsDataURL(input.files[0]); // Read the file as a data URL
    }
}

</script>
@endsection