@extends('layouts.app')
@section('meta')
    <title> @lang('home.order_details')</title>
@endsection
@section('content')

@include('website.banner', [
    'bannerTitle' =>__('home.order_details'),
])
        <!-- page-cart -->
        <section class="flat-spacing-11">
            <div class="container">
                <div class="row">
                    @include('website.user.links')

                    <div class="col-lg-9">
                        <div class="wd-form-order">
                            <div class="order-head">
                                {{-- <figure class="img-product">
                                    <img src="{{$order->product_main_image}}" alt="product">
                                </figure> --}}
                                <div class="content">
                                    <div class="badge"> {{ $order->status_current}} </div>
                                    <h6 class="mt-8 fw-5">{{ $order->number}}</h6>
                                </div>
                            </div>
                            <div class="tf-grid-layout md-col-2 gap-15">
                                {{-- <div class="item">
                                    <div class="text-2 text_black-2">@lang('home.product_name')</div>
                                    <div class="text-2 mt_4 fw-6">{{ $order->product_name }}</div>
                                </div> --}}
                                {{-- <div class="item">
                                    <div class="text-2 text_black-2">@lang('category')</div>
                                    <div class="text-2 mt_4 fw-6">{{ $order->product_category_name}}</div>
                                </div> --}}
                                <div class="item">
                                    <div class="text-2 text_black-2">@lang('home.order_date')</div>
                                    <div class="text-2 mt_4 fw-6"> {{date_format($order->created_at , 'Y MM d')}} </div>
                                </div>
                                <div class="item">
                                    <div class="text-2 text_black-2">@lang('home.address')</div>
                                    <div class="text-2 mt_4 fw-6">{{ $order->address_full}}</div>
                                </div>
                            </div>
                            <div class="widget-tabs style-has-border widget-order-tab">
                                <ul class="widget-menu-tab">
                                    <li class="item-title active">
                                        <span class="inner">@lang('home.order_tracking')</span>
                                    </li>
                                    <li class="item-title">
                                        <span class="inner">@lang('home.items')</span>
                                    </li>
                                    {{-- <li class="item-title">
                                        <span class="inner">Courier</span>
                                    </li> --}}
                                    <li class="item-title">
                                        <span class="inner">@lang('home.delivered')</span>
                                    </li>
                                </ul>
                                <div class="widget-content-tab">
                                    <div class="widget-content-inner active">
                                        <div class="widget-timeline">
                                            <ul class="timeline">
                                                @foreach ($all_status as $status)
                                                    @php
                                                        $status_in_order = $order->orderStatus->where('status', $status)->first();
                                                    @endphp
                                                    @if ($status_in_order)
                                                        <li>
                                                            <div class="timeline-badge success"></div>
                                                            <div class="timeline-box">
                                                                <a class="timeline-panel" href="javascript:void(0);">
                                                                    <div class="text-2 fw-6">@lang("home.$status")</div>
                                                                    <span>{{ date_format($status_in_order->created_at, 'Y/m/d H:i:s') }}</span>
                                                                </a>
                                                            </div>
                                                        </li>
                                                    @else
                                                        <li>
                                                            <div class="timeline-badge"></div>
                                                            <div class="timeline-box">
                                                                <a class="timeline-panel" href="javascript:void(0);">
                                                                    <div class="text-2 fw-6">@lang("home.$status")</div>
                                                                </a>
                                                            </div>
                                                        </li>
                                                    @endif
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>
                                    <div class="widget-content-inner">
                                        @foreach ($order->products as $product)
                                            <div class="order-head">
                                                <figure class="img-product">
                                                    <img src="{{ $product->product_main_image }}" alt="product">
                                                </figure>
                                                <div class="content">
                                                    <div class="text-2 fw-6">{{$product->product_name}}</div>
                                                    <div class="mt_4"><span class="fw-6">@lang('home.price'): </span> {{$product->quantity}} * {{$product->price}} = ( {{$product->quantity * $product->price}} ) @lang('home.EGP')</div>
                                                    <div class="mt_4"><span class="fw-6">@lang('home.discount'): </span>  {{$product->quantity}} *  -{{$product->product_discount}} = ( {{$product->quantity *  -$product->product_discount}} )  @lang('home.EGP')</div>
                                                    <div class="mt_4"><span class="fw-6">@lang('home.sub_total_price'): </span>   {{$product->total}}  @lang('home.EGP')</div>
                                                </div>
                                            </div>
                                        @endforeach

                                        <ul>
                                            <li class="d-flex justify-content-between text-2">
                                                <span>@lang('home.price')</span>
                                                <span class="fw-6">{{$order->price}} @lang('home.EGP')</span>
                                            </li>

                                            <li class="d-flex justify-content-between text-2">
                                                <span>@lang('home.shipping_fees')</span>
                                                <span class="fw-6">{{$order->shipping_fees}} @lang('home.EGP')</span>
                                            </li>

                                            <li class="d-flex justify-content-between text-2 mt_4 pb_8 line">
                                                <span>@lang('home.Coupon Discount')</span>
                                                <span class="fw-6">{{ $order->coupon_discount}}  @lang('home.EGP')</span>

                                            </li>
                                            <li class="d-flex justify-content-between text-2 mt_8">
                                                <span>@lang('home.total_price')</span>
                                                <span class="fw-6">{{ $order->total_price}}  @lang('home.EGP')</span>
                                            </li>
                                        </ul>

                                    </div>
                                    {{-- <div class="widget-content-inner">
                                        <p>Our courier service is dedicated to providing fast, reliable, and secure delivery solutions tailored to meet your needs. Whether you're sending documents, parcels, or larger shipments, our team ensures that your items are handled with the utmost care and delivered on time. With a commitment to customer satisfaction, real-time tracking, and a wide network of routes, we make it easy for you to send and receive packages both locally and internationally. Choose our service for a seamless and efficient delivery experience.</p>
                                    </div> --}}
                                    <div class="widget-content-inner">
                                        <p class="text-2 text_success">@lang('home.thank you your order placed successfully')</p>
                                        <ul class="mt_20">
                                            <li>@lang('home.order_number'): <span class="fw-7"> {{$order->number}} </span></li>
                                            <li>@lang('date'): <span class="fw-7"> {{$order->status_current == 'delivared' ? date_format($order->status?->created_at , 'Y/m/d H:i:s' ) : __('home.process') }}</span></li>
                                            <li>@lang('home.total'): <span class="fw-7">{{ $order->total_price}}  @lang('home.EGP')</span></li>
                                            <li>@lang('home.payment_method'): <span class="fw-7">{{ $order->payment_method }}</span></li>

                                        </ul>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- page-cart -->
@endsection
@section('script')
<script>
    function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('user-image-preview');

    if (input.files && input.files[0]) {
        const reader = new FileReader();

        reader.onload = function(e) {
            preview.src = e.target.result; // Set the preview image's src to the file's data URL
        };

        reader.readAsDataURL(input.files[0]); // Read the file as a data URL
    }
}

</script>
@endsection