@extends('layouts.app')
@section('meta')
    @php echo $metatags @endphp
    @php echo $schema @endphp
@endsection
@section('content')

    @include('website.banner',['bannerTitle' =>  __('home.categories') ])

    <section class="flat-spacing-30 flat-control-sw">
        <div class="container">
            <div class="flat-title flex-row justify-content-between px-0">
                <span class="title fw-6 wow fadeInUp" data-wow-delay="0s">@lang('home.categories')</span>
                <div class="box-sw-navigation">
                    <div class="sw-dots style-2 medium sw-pagination-recent justify-content-center"></div>
                </div>
            </div> 
            <div dir="ltr" class="swiper tf-sw-recent wow fadeInUp" data-preview="6" data-tablet="3" data-mobile="2" data-space-lg="30" data-space-md="30" data-space="15" data-pagination="2" data-pagination-md="3" data-pagination-lg="3">
                <div class="swiper-wrapper">
                    @foreach($categories as $category)
                        <div class="swiper-slide">
                            <div class="collection-item-circle has-bg has-bg-2 hover-img">
                                <a href="{{LaravelLocalization::localizeUrl('category/'.$category->link)}}" class="collection-image img-style">
                                    <img class="lazyload" data-src="{{$category->image_source}}" alt="collection-img" src="{{$category->image_source}}">
                                </a>
                                <div class="collection-content text-center">
                                    <a href="{{LaravelLocalization::localizeUrl('category/'.$category->link)}}" class="link title fw-5"> {{ $category->name }}</a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endsection
@section('script')
@endsection
