<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_menu_item')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.menu_items')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/menus')); ?>"><?php echo e(trans('home.menu_items')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_menu_item')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->
        
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_menu_item')); ?></h6>
                        </div>
                        <?php echo Form::open(['method'=>'PATCH','url' => 'admin/menu-items/'.$menuItem->id, 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e($menuItem->name_en); ?>" required>
                                </div>

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($menuItem->name_ar); ?>" required>
                                </div>

                                <div class="form-group col-md-3"> 
                                    <label for="parent"><?php echo e(trans('home.parent')); ?></label>
                                    <select class="form-control select2 parent" name="parent">
                                        <option value ="0"><?php echo e(trans('home.no_parent')); ?></option>
                                        <?php $__currentLoopData = $menuParents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menuParent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($menuParent->id); ?>" <?php echo e(($menuParent->id == $menuItem->parent_id)?'selected':''); ?>><?php if(app()->getLocale() == 'en'): ?> <?php echo e($menuParent->name_en); ?> <?php else: ?> <?php echo e($menuParent->name_ar); ?> <?php endif; ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-3"> 
                                    <fieldset class="form-group">
                                        <label for="order"><?php echo e(trans('home.order')); ?></label>
                                        <input type="number" min="1"  class="form-control" placeholder="<?php echo e(trans('home.order')); ?>" name="order" value="<?php echo e($menuItem->order); ?>" required>
                                    </fieldset>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="row"> 
                                        <div class="form-group col-md-4"> 
                                            <label for="menu"><?php echo e(trans('home.menu')); ?></label>
                                            <select class="form-control select2 menu" name="menu_id">
                                                <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($menu->id); ?>" <?php echo e(($menu->id == $menuItem->menu_id)?'selected':''); ?>><?php echo e((app()->getLocale() == 'en')?$menu->name_en:$menu->name_ar); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="form-group col-md-4"> 
                                            <label for="menu_type"><?php echo e(trans('home.menu_type')); ?></label>
                                            <select class="form-control select2 menu_type" name="menu_type" required>
                                                <option></option>
                                                <option value="main-item" <?php echo e(($menuItem->type == 'main-item')?'selected':''); ?>><?php echo e(trans('home.main-item')); ?></option>
                                                <option value="home" <?php echo e(($menuItem->type == 'home')?'selected':''); ?>><?php echo e(trans('home.home')); ?></option>
                                                <option value="indvidual-registration/login" <?php echo e(($menuItem->type == 'about-us')?'selected':''); ?>><?php echo e(trans('home.about-us')); ?></option>
                                                <option value="contact-us" <?php echo e(($menuItem->type == 'contact-us')?'selected':''); ?>><?php echo e(trans('home.contact-us')); ?></option>
                                                <!--<option value="board-of-members" <?php echo e(($menuItem->type == 'board-of-members')?'selected':''); ?>><?php echo e(trans('home.boardofmembers')); ?></option>-->
                                                <option value="categories" <?php echo e(($menuItem->type == 'categories')?'selected':''); ?>><?php echo e(trans('home.categories')); ?></option>
                                                <option value="career" <?php echo e(($menuItem->type == 'career')?'selected':''); ?>><?php echo e(trans('home.career')); ?></option>
                                                <option value="category" <?php echo e(($menuItem->type == 'category')?'selected':''); ?>><?php echo e(trans('home.category')); ?></option>
                                                <option value="projects" <?php echo e(($menuItem->type == 'projects')?'selected':''); ?>><?php echo e(trans('home.projects')); ?></option>
                                                <option value="project" <?php echo e(($menuItem->type == 'project')?'selected':''); ?>><?php echo e(trans('home.project')); ?></option>
                                                <option value="services" <?php echo e(($menuItem->type == 'services')?'selected':''); ?>><?php echo e(trans('home.services')); ?></option>
                                                <option value="service" <?php echo e(($menuItem->type == 'service')?'selected':''); ?>><?php echo e(trans('home.service')); ?></option>
                                                <option value="galleryImages" <?php echo e(($menuItem->type == 'galleryImages')?'selected':''); ?>><?php echo e(trans('home.galleryImages')); ?></option>
                                                <option value="certificates" <?php echo e(($menuItem->type == 'certificates')?'selected':''); ?>><?php echo e(trans('home.certificates')); ?></option>
                                                <option value="company-registration/login" <?php echo e(($menuItem->type == 'galleryVideos')?'selected':''); ?>><?php echo e(trans('home.galleryVideos')); ?></option>
                                                <option value="brand" <?php echo e(($menuItem->type == 'brand')?'selected':''); ?>><?php echo e(trans('home.brand')); ?></option>
                                                <option value="pages" <?php echo e(($menuItem->type == 'pages')?'selected':''); ?>><?php echo e(trans('home.pages')); ?></option>
                                                <option value="blogs" <?php echo e(($menuItem->type == 'blogs')?'selected':''); ?>><?php echo e(trans('home.blogs')); ?></option>
                                                <option value="blog-category" <?php echo e(($menuItem->type == 'blog-category')?'selected':''); ?>><?php echo e(trans('home.blog-category')); ?></option>
                                                <option value="blog-item" <?php echo e(($menuItem->type == 'blog-item')?'selected':''); ?>><?php echo e(trans('home.blog-item')); ?></option>
                                                <option value="link" <?php echo e(($menuItem->type == 'link')?'selected':''); ?>><?php echo e(trans('home.link')); ?></option>
                                                 <option value="Vision,-mission-and-values" <?php echo e(($menuItem->type == 'Vision,-mission-and-values') ? 'selected' : ''); ?>><?php echo e(trans('home.vision_mission_values')); ?></option>
                                                <option value="Speech-of-the-Managing-Director-and-President" <?php echo e(($menuItem->type == 'Speech-of-the-Managing-Director-and-President') ? 'selected' : ''); ?>><?php echo e(trans('home.md_ceo_statement')); ?></option>
                                                <option value="Sharia-supervision" <?php echo e(($menuItem->type == 'Sharia-supervision') ? 'selected' : ''); ?>><?php echo e(trans('home.sharia_advisory')); ?></option>
                                                <option value="Board-of-Directors" <?php echo e(($menuItem->type == 'Board-of-Directors') ? 'selected' : ''); ?>><?php echo e(trans('home.board_of_directors')); ?></option>
                                                <option value="Board-committees" <?php echo e(($menuItem->type == 'Board-committees') ? 'selected' : ''); ?>><?php echo e(trans('home.board_committees')); ?></option>
                                                <option value="Contributors" <?php echo e(($menuItem->type == 'Contributors') ? 'selected' : ''); ?>><?php echo e(trans('home.shareholders')); ?></option>
                                                <option value="Management-team" <?php echo e(($menuItem->type == 'Management-team') ? 'selected' : ''); ?>><?php echo e(trans('home.management_team')); ?></option>
                                                <option value="Organizational-Chart" <?php echo e(($menuItem->type == 'Organizational-Chart') ? 'selected' : ''); ?>><?php echo e(trans('home.organizational_structure')); ?></option>
                                                <option value="investment-opportunities" <?php echo e(($menuItem->type == 'investment-opportunities') ? 'selected' : ''); ?>><?php echo e(trans('home.investment_opportunities')); ?></option>
                                                <option value="Periodic-reports" <?php echo e(($menuItem->type == 'Periodic-reports') ? 'selected' : ''); ?>><?php echo e(trans('home.periodic_reports')); ?></option>
                                                <option value="Corporate-governance-framework" <?php echo e(($menuItem->type == 'Corporate-governance-framework') ? 'selected' : ''); ?>><?php echo e(trans('home.corporate_governance_framework')); ?></option>
                                                <option value="Investors%27-rights" <?php echo e(($menuItem->type == 'Investors%27-rights') ? 'selected' : ''); ?>><?php echo e(trans('home.investors_rights')); ?></option>

                                            </select>
                                        </div>

                                        <div class="form-group col-md-4"> 
                                            <div class="type_values">

                                            <?php if($menuItem->type == 'product' || $menuItem->type == 'brand' || $menuItem->type == 'category'): ?>
                                                <fieldset class="form-group">
                                                    <label for="blog_categories"><?php echo e(trans("home.$menuItem->type")); ?></label>
                                                    <select class="form-control select2 type_value" name="type_value"  id="type_value">
                                                        <?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($value -> id); ?>" <?php echo e(($menuItem->type_value == $value->id)?'selected':''); ?>><?php if(app()->getLocale() == 'en'): ?> <?php echo e($value -> name_en); ?> <?php else: ?> <?php echo e($value -> name_ar); ?><?php endif; ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </fieldset>
                                            <?php elseif($menuItem->type == 'blog-category' || $menuItem->type == 'blog-item' ||$menuItem->type == 'pages' ||$menuItem->type == 'service' ||$menuItem->type == 'project'): ?>
                                                <fieldset class="form-group">
                                                    <label for="blog_categories"><?php echo e(trans("home.$menuItem->type")); ?></label>
                                                    <select class="form-control select2 type_value" name="type_value"  id="type_value">
                                                        <?php $__currentLoopData = $values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($value -> id); ?>" <?php echo e(($menuItem->type_value == $value->id)?'selected':''); ?>><?php if(app()->getLocale() == 'en'): ?> <?php echo e($value -> name_en); ?> <?php else: ?> <?php echo e($value -> name_ar); ?><?php endif; ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </fieldset>   
                                            <?php elseif($menuItem->type == 'home' || $menuItem->type == 'about-us' || $menuItem->type == 'contact-us' || $menuItem->type =='board-of-members' || $menuItem->type =='galleryImages'): ?>
                                              <fieldset class="form-group">
                                              </fieldset>
                                            <?php elseif($menuItem->type == 'link'): ?> 
                                                <fieldset class="form-group">
                                                  <label for="regions"><?php echo e(trans('home.link')); ?></label>
                                                  <input type="text" class="form-control type_value" placeholder="<?php echo e(trans('home.link')); ?>" name="type_value" value="<?php echo e($menuItem->type_value); ?>">
                                                </fieldset>
                                            <?php endif; ?>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-6">
                                    <label for="menu"><?php echo e(trans('home.meta_keywords')); ?></label>
                                    <textarea class="form-control " name="meta_keywords" placeholder="<?php echo e(trans('home.meta_keywords')); ?>" ><?php echo e($menuItem->meta_keywords); ?></textarea>
                                </div>

                                <div class="form-group col-md-6"> 
                                    <label for="menu"><?php echo e(trans('home.meta_description')); ?></label>
                                    <textarea class="form-control " name="meta_description" placeholder="<?php echo e(trans('home.meta_description')); ?>" ><?php echo e($menuItem->meta_description); ?></textarea>
                                </div>

                                <div class="form-group col-md-12">
                                  <label class="ckbox">
                                      <input name="status" value="1" <?php echo e(($menuItem->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                  </label>
                              </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/menu-items')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $('.status').select2();
        $('.menu').select2();
        $('.menu_type').select2({
            'placeholder' : "<?php echo e(trans('home.choose_menu_type')); ?>",
        });
        $('.parent').select2();


    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/nomw/resources/views/admin/menuItems/editMenuItem.blade.php ENDPATH**/ ?>