<?php $__env->startSection('meta'); ?>
    <?php echo $metatags ?>

    <?php echo $schema ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-------------------Breadcrumb----------------------->
    <section class="breadcrumb-area about">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="breadcrumb-item">
                        <h2 class="title"><?php echo e(trans('home.career')); ?></h2>
                    </div>  
                </div>
            </div>
        </div>
    </section>
    <!------------------- End Breadcrumb----------------------->

    <!------------------------------------------------- Start Employee details page ------------------------------------------------->
    <section id="employee">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-6 col-lg-4 right">
                    <div class="card text-end">
                        <div class="card-body">
                          <h5 class="card-title"><?php echo e(trans('home.Job vacancies')); ?></h5>
                          <p class="card-text"><?php echo e(trans('home.CV can be sent by e-mail')); ?></p>
                          <a href="mailto:<?php echo e($setting->contact_email); ?>" class="btn btn-primary"><?php echo e($setting->contact_email); ?></a>
                          <p class="desc"><?php echo e(trans('home.With the need to write the name of the job according to what is written in the table of current jobs in the subject field of the email, or write “CV” for other than the jobs offered.')); ?></p>

                        </div>
                      </div>
                      
                </div>
                <div class="col-sm-12 col-md-6 col-lg-8 left">
                    <div class="desc-title">
                        <h4><?php echo e(trans('home.Thank you for your interest in working at Nomou Capital.')); ?></h4>
                        <p><?php echo e(trans('home.We at Nomou Capital seek to employ distinguished national cadres who have a high level of professional ambition and give them the opportunity to build a promising future. Nomou Capital is committed to training and developing its employees through advanced programs to increase their knowledge, competencies and production capabilities. Nomou Capital also offers competitive salaries, allowances, bonuses and annual bonuses.')); ?></p>
                    </div>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-12">
                    <div class="social-sec">
                        <div class="d-inline-block pr-4 left"><?php echo e(trans('home.Share on social networks')); ?></div>
                        <div class="d-inline-block pr-4 float-right">
                            <ul>
                            <?php if(!empty($setting->whatsapp)): ?>
                                <li><a href="https://wa.me/<?php echo e($setting->whatsapp); ?>"><i class="fontello icon-whatsapp"></i></a></li>
                            <?php endif; ?>
                            <?php if(!empty($setting->twitter)): ?>
                                <li><a href="<?php echo e($setting->twitter); ?>"><i class="fontello icon-twitter-1"></i></a></li>
                            <?php endif; ?>
                            <?php if(!empty($setting->facebook)): ?>
                                <li><a href="<?php echo e($setting->facebook); ?>"><i class="fontello icon-facebook-1"></i></a></li>
                            <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-------------------------------------------------- End  Employee details page ------------------------------------------------->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e(config('services.recaptcha.sitekey')); ?>"></script>
    <script>
         grecaptcha.ready(function() {
             grecaptcha.execute('<?php echo e(config('services.recaptcha.sitekey')); ?>', {action: 'contact'}).then(function(token) {
                if (token) {
                  document.getElementById('recaptcha').value = token;
                }
             });
         });
    </script>
    <script>
        $('form').submit(function() {
            $(this).find("button[type='submit']").prop('disabled',true);
        });
    </script>

    <?php if(Session::has('success')): ?>
        <script>
            $.alert({
                title: "<?php echo e(trans('home.applicationSentSuccessfully')); ?>",
                content: "<?php echo e(Session::get('success')); ?>",
                buttons: {
                    ok: {
                        text: "<?php echo e(trans('home.OK')); ?>",
                        btnClass: 'btn main-btn',
                    },
                },
                columnClass: 'col-md-6'
            });
        </script>
    <?php endif; ?>
    <?php
        Session::forget('success')
    ?>
<?php $__env->stopSection(); ?>    
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest2/public_html/nomw/resources/views/website/career.blade.php ENDPATH**/ ?>