<?php

namespace App\Http\Controllers;

use App\Models\Subheader;
use App\Traits\Common;
use GuzzleHttp\Psr7\UploadedFile;
use Illuminate\Http\Request;

class SubheaderController extends Controller
{
    use Common;
    
    /**
     * Display a listing of the resource.
     */
    
    
    public function index()
    {
        //
        $subheaders = Subheader::get();
        return view('admin/subheaders/subheaders', compact('subheaders'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        return view('admin/subheaders/addsubheader');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        // dd($request->all());
        $data = $request->all();
        $data['status'] = isset($request['status']);
        
        if($request->hasFile('image'))
        {
            $data['image']=  $this->uploadFile($request['image'],'uploads/subheader/source/');
        }
        Subheader::create($data);
        return redirect('admin/subheaders')->with('success',__('home.your_item_added_successfully'));
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
        $subheader = Subheader::findOrFail($id);
        if($subheader){
        return view('admin/subheaders/editSubHeader',compact('subheader'));
        }
        else{
            abort('404');
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $data = $request->except('_token','_method');
        $data['status'] = isset($request['status']);
        if($request->has('image'))
        {
            $data['image']= $this->uploadFile($request['image'],'uploads/subheader/source');
        }

        Subheader::where('id',$id)->update($data);

        return redirect('admin/subheaders')->with('success',__('home.your_item_added_successfully'));
    }
    

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
