@extends('layouts.app')
@section('title')
    {{-- @php echo $metatags @endphp --}}
    {{-- @php echo $schema @endphp --}}
@endsection
@section('name', 'Team')

@section('BreadCrumb', $team->{'name_' . $lang})
@section('BreadCrumb2', __('home.team'))

@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->

@include('website.web-partials.BreadCrumb')
<!-- <================================================================= BreadCrumb =======================================================> -->
<section class="team-details pt-120 pb-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="team-details-content fade-wrapper">
                    <div class="section-heading mb-40">
                        <h4 class="sub-heading" ><span>//</span>{{$team->{'name_'.$lang} }}</h4>
                        <h2 class="section-title" >Member of<br> <span>Information</span></h2>
                    </div>
                    <div class="team-details-list-wrap">
                        <ul class="team-details-list fade-top">
                            <li>Specialization : <span>{{$team->{'position_'.$lang} }}</span></li>
                            <li>Email : <a href="mailto:{{$team->email}}" target="_blank">{{$team->email}}</a></li>
                            <li>Phone : <a href="tel:{{$team->mobile}}" target="_blank">{{$team->mobile}}</a></li>

                        </ul>
                        <ul class="team-details-list fade-top">
                            @foreach ($addresses as $index => $address)
                            @if ($index < 2)
                           <li> Clinic Address : <span><a href="https://www.google.com/maps/search/?api=1&query={{ urlencode($address->address_en) }}"
                                        target="_blank">{{ $address->address_en }}</a></li></span>
                            @endif
                        @endforeach
                        </ul>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="team-details-img">
                    <ul class="social-list">
                        @if ($team->facebook)
                        <li class="facebook">
                            <a href="{{ $team->facebook }}" target="_blank"><i class="fab fa-facebook-f"></i></a>
                        </li>
                        @endif
                        @if ($team->instgram)
                        <li class="instagram">
                            <a href="{{$team->instgram}}" target="_blank"><i class="fab fa-instagram"></i></a>
                        </li>
                        @endif
                        @if ($setting->facebook)
                        <li class="facebook">
                            <a href="{{ $setting->facebook }}" target="_blank"><i class="fab fa-facebook-f"></i></a>
                        </li>
                        @endif
                        @if ($setting->instgram)
                        <li class="instagram">
                            <a href="{{ $setting->instgram }}" target="_blank"><i class="fab fa-instagram"></i></a>
                        </li>
                        @endif
                    </ul>
                    <div class="img-wrap">
                        <img src="{{Helper::uploadedImagesPath('teams',$team->img)}}" alt="img">
                        <div class="content">
                            <span>{{$team->{'position_'.$lang} }}</span>
                            <h3 class="name">{{$team->{'name_'.$lang} }}</h3>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
<!-- ./ team-details -->
