<?php

use App\Http\Controllers\SubheaderController;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;


Route::group([
    'middleware' => ['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'],
    'prefix' => LaravelLocalization::setLocale()
], function () {
    Route::get('/sitemap.xml', 'SiteMapController@index');
    Route::get('/services-sitemap.xml', 'SiteMapController@services');
    Route::get('/brands-sitemap.xml', 'SiteMapController@brands');
    Route::get('/categories-sitemap.xml', 'SiteMapController@categories');
    Route::get('/projects-sitemap.xml', 'SiteMapController@projects');
    Route::get('/pages-sitemap.xml', 'SiteMapController@pages');
    Route::get('/blogs-sitemap.xml', 'SiteMapController@blogs');


    Route::get('/lang/{lang}', 'AdminController@setlang');
    Route::get('/', 'WebsiteController@home')->name('home');
    Route::get('about-us', 'WebsiteController@aboutUs')->name('about-us');
    Route::get('sustainability','WebsiteController@aboutstrucs');
     Route::get('product','WebsiteController@product');
    Route::get('contact-us', 'WebsiteController@contactUs')->name('contact-us');
    Route::post('save/contact-us', 'WebsiteController@saveContactUs')->name('contact.save');
    Route::get('page/{link}', 'WebsiteController@getPage');


    Route::get('service/{link}', 'WebsiteController@getServiceDetails');
    Route::get('blog/{link}', 'WebsiteController@getBlogPage');
    Route::get('brand/{link}', 'WebsiteController@getBrandPage');
    Route::get('about-writer/{id}', 'WebsiteController@getWriter')->name('writer.details');
    Route::get('services', 'WebsiteController@getservices')->name('services');
    // Route::get('Gallery-Photo', 'WebsiteController@getGalleryImages')->name('galleryImages');
    Route::get('Gallery-Photo/{type}', 'WebsiteController@getGalleryImages')->name('galleryImages');
    Route::get('blogs/{link?}', 'WebsiteController@getBlogs')->name('blogs');
    Route::get('brands', 'WebsiteController@getBrands');
    Route::get('Gallery-Videos', 'WebsiteController@getGalleryVideos');
    Route::post('save/comment', 'WebsiteController@saveComment');
    Route::get('careers', 'WebsiteController@getTeam');
    // Route::get('team/{link}' , 'WebsiteController@getTeamDetails');
    Route::get('about/{link}' , 'WebsiteController@getTeamDetails');
    Route::get('about-doctor1','WebsiteController@getTeamDetails');
    Route::get('about-doctor2','WebsiteController@getTeamDetails');

    Route::get('projects', 'WebsiteController@getProjects');
    Route::get('developer/{link}/projects', 'WebsiteController@getDeveloperProjects');
    Route::get('category/{link}/projects', 'WebsiteController@getCategoryProjects');
    Route::get('recommended/projects', 'WebsiteController@getRecommendedProjects');
    Route::get('project/{link}', 'WebsiteController@getProductDetails');
    Route::get('search-for', 'WebsiteController@projectsSearchResults');
    Route::post('save-career-application', 'WebsiteController@saveCareerApplication');

    Route::get('searchAutoComplete', 'WebsiteController@autoCompletesearch');
    Route::post('save/training-applications', 'WebsiteController@saveTrainingApplications');
    // Route::get('celebrity-testimonial','WebsiteController@getTestimonialDetails');
    // Route::get('patient-testimonial','WebsiteController@getTestimonialDetails');
    Route::get('testimonial/{type}', 'WebsiteController@getTestimonialDetails');

     Route::get('category/{link}', 'WebsiteController@getCategoryProducts');
     Route::get('faq','WebsiteController@showFaq');
});


Route::group(['middleware' => ['admin', 'web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'], 'prefix' => LaravelLocalization::setLocale()], function () {
    Route::group(['prefix' => 'admin'], function () {
        Route::get('', 'AdminController@admin');
        Route::get('translations', 'AdminController@translations');
        Route::get('/switch-theme', 'AdminController@switchTheme');
        Route::get('/switch-theme-topbar', 'AdminController@switchThemeTop');
        Route::get('/switch-theme-sidebar/{sidebar}', 'AdminController@switchThemeSidebar');
        Route::post('{name}/up/{ids}', 'AdminController@updatestatus');
        Route::resource('/countries', 'CountryController');
        Route::resource('/regions', 'RegionController');
        Route::resource('/areas', 'AreaController');
        Route::resource('/settings', 'SettingController');
        Route::resource('/writers', 'WriterController');
        Route::resource('/configrations', 'ConfigrationController');
        Route::resource('users', 'UserController');
        Route::resource('roles', 'RoleController');
        Route::resource('permissions', 'PermissionController');
        Route::resource('/categories', 'CategoryController');
        Route::resource('pages', 'PageController');
        Route::resource('menus', 'MenuController');
        Route::resource('menu-items', 'MenuItemController');
        Route::post('menuTypeValue', 'MenuItemController@menuTypeValue')->name('menuTypeValue');
        Route::resource('intro-sliders', 'IntroSliderController');
        Route::resource('home-sliders', 'HomeSliderController');
        Route::resource('offers-sliders', 'OfferSliderController');
        Route::resource('services', 'ServiceController');
        Route::post('services/copy', 'ServiceController@copy')->name('servicesCopy');
        Route::post('services/deleteAllIMages', 'ServiceController@deleteAllIMages');



        // Route::resource('footer','FooterController');
        Route::get('footer', 'FooterController@create');
        Route::post('footer', 'FooterController@store')->name('footer');

        Route::resource('subheaders','SubheaderController');
        //  Route::get('subheader','SubheaderController@create');
        //  Route::post('subheaders/addsubheader','SubheaderController@store')->name('addsubheader');
        Route::get('forms','SubheaderController@create');
        Route::post('subheaders/addform','SubheaderController@store')->name('addform');

        Route::post('services/uploadImages', 'ServiceController@uploadImages');
        Route::post('services/removeUploadImages', 'ServiceController@removeUploadImages');
        Route::post('services/deleteImege', 'ServiceController@deleteImege');
        Route::get('editAbout', 'AboutController@editAbout')->name('admin.editAbout');
        Route::PATCH('about/update', 'AboutController@update')->name('admin.about.update');
        Route::post('menuTypeValue', 'MenuItemController@menuTypeValue')->name('menuTypeValue');
        Route::resource('aboutStrucs', 'AboutStrucController');
        Route::resource('contact-us-messages', 'ContactusController');
        Route::get('contacts', 'ContactusController@indexmail')->name('contacts.index');
        Route::post('contacts/send', 'ContactusController@sendEmail')->name('contacts.send');
        Route::resource('brands', 'BrandController');
        Route::resource('pages', 'PageController');
        Route::resource('blog-categories', 'BlogCategoryController');
        Route::resource('blog-items', 'BlogItemController');
        Route::resource('teams', 'TeamController');
        Route::post('blog-items/copy', 'BlogItemController@copy')->name('BlogItemCopy');
        Route::post('updateFaq', 'BlogItemController@updateFaq')->name('updateFaq');
        Route::post('removeFaq', 'BlogItemController@removeFaq')->name('removeFaq');
        Route::resource('home-images', 'HomeImageController');
        Route::resource('gallery-images', 'GalleryImageController');
        Route::post('gallery-images/deleteImege', 'GalleryImageController@deleteImege');
        Route::post('gallery-images/reorder', 'GalleryImageController@reorderImeges');
        Route::get('gallery-image/create-pluck', 'GalleryImageController@createPluck');
        Route::post('gallery-images/uploadImages', 'GalleryImageController@uploadImages');
        Route::post('gallery-images/removeUploadImages', 'GalleryImageController@removeUploadImages');
        Route::post('gallery-images/storePluck', 'GalleryImageController@storePluck');
        Route::resource('testimonials', 'TestimonialController');
        Route::resource('news-letters', 'NewsLetterController');
        Route::resource('projects', 'ProjectController');
        Route::post('projects/copy', 'ProjectController@copy')->name('ProjectsCopy');
        Route::post('/projects/{project}/deleteFile', 'ProjectController@deleteFile')->name('deleteFile');
        Route::post('projects/changeCategory/{id}', 'ProjectController@changeCategory');
        Route::post('services/{service}/deleteFile', 'ServiceController@deleteFile')->name('deleteFile');
        Route::post('album-images/deleteImage', 'AlbumItemController@deleteImage');

        // Albums
        Route::resource('albums', 'AlbumController');
        Route::post('albums/deleteAllIMages', 'AlbumItemController@deleteAllIMages');
        Route::post('albums/AlbumItemCopy', 'AlbumController@copy')->name('AlbumItemCopy');
        Route::resource('album-images', 'AlbumItemController');
        Route::post('album-images/uploadImages', 'AlbumItemController@uploadImages');
        Route::post('album-images/removeUploadImages', 'AlbumItemController@removeUploadImages');



        Route::post('projects/uploadImages', 'ProjectController@uploadImages');
        Route::post('projects/removeUploadImages', 'ProjectController@removeUploadImages');
        Route::post('projects/deleteImege', 'ProjectController@deleteImege');
        Route::post('projects/deleteAllIMages', 'ProjectController@deleteAllIMages');
        Route::resource('addresses', 'AddressController');
        Route::resource('gallery-videos', 'GalleryVideoController');
        Route::post('gallery-videos/reorder', 'GalleryVideoController@reorderVideos');
        Route::resource('seo-assistant', 'SeoAssistantContoller');
        Route::resource('faqs', 'FaqController');
        Route::get('editFaq', 'FaqController@editFaq');
        Route::post('storeFaq', 'FaqController@storeFaq');
        Route::post('updateGeneralFaq', 'FaqController@updateGeneralFaq')->name('updateGeneralFaq');
        Route::post('removeGeneralFaq', 'FaqController@removeGeneralFaq')->name('removeGeneralFaq');

        Route::resource('/attributes', 'AttributeController');
        Route::post('removeAttributeValue', 'AttributeController@removeAttributeValue')->name('removeAttributeValue');
        Route::post('updateAttributeValue', 'AttributeController@updateAttributeValue')->name('updateAttributeValue');

        Route::resource('careers', 'CareerController');
        Route::resource('dates', 'DateController');
        Route::get('careers-applications', 'CareerController@getCareersApplications');
        Route::resource('phones', 'PhoneController');
        Route::resource('progresses', 'ProgressController');
    });
});

//////////// clearing cach and cache config///////
Route::get('/clear-cache', function () {
    $exitCode = Artisan::call('optimize:clear');
    return 'DONE'; //Return anything
});

Route::group(['middleware' => ['web', 'localeSessionRedirect', 'localizationRedirect', 'localeViewPath'], 'prefix' => LaravelLocalization::setLocale()], function () {
    Auth::routes();
    Route::get('{menu}', 'WebsiteController@menus');
});
