<div class="sidebar-box-area sidebar-bg mb-40">
    <h3><?php echo e(__('home.Get A Free Quote')); ?></h3>
    <div class="contact-form">
        <form action="<?php echo e(route('contact.save')); ?>" method="Post" id="ajax-contact" novalidate>
            <?php echo csrf_field(); ?>
            <div id="success-message" style="color: green;"></div>
            <div class="single-input">
                <input type="text" placeholder="Your Name" name="name" id="name">
                <div class="alert alert-danger print-error-msg" id="error-name"
                    style="display:none; color: red;"></div>
            </div>
            <div class="single-input">
                <input type="email" placeholder="Email Address" name="email" id="email">
                <div class="alert alert-danger print-error-msg" id="error-email"
                    style="display:none; color: red;">
                </div>
            </div>

            <div class="single-input">
                <input type="phone" placeholder="Phone Number" name="phone" id="phone">
                <div class="alert alert-danger print-error-msg" id="error-phone"
                    style="display:none; color: red;">
                </div>
            </div>

            <div class="single-input">
                <textarea placeholder="Your Message" cols="30" rows="3" name="message" id="message"></textarea>
                <div class="alert alert-danger print-error-msg" id="error-message"
                    style="display:none; color: red;">
                </div>
            </div>

            <div class="button">
                <button type="submit" class="theme-btn1"><?php echo e(__('home.Learn More')); ?> <span><i
                            class="fa-solid fa-arrow-right"></i></span></button>
            </div>
        </form>
    </div>
</div>
<?php $__env->startSection('script'); ?>
    <script>
        $('#ajax-contact').on('submit', function(e) {
            e.preventDefault();
            $('.print-error-msg').hide().text('');
            $('#success-message').text('');

            const url = $(this).attr('action');
            let formData = new FormData(this);

            $.ajax({
                url: url,
                method: "POST",
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                success: (response) => {
                    $('#success-message').text(response);
                    $('#ajax-contact')[0].reset();
                },
                error: (response) => {
                    console.log('Error Response:', response);
                    console.log('Errors:', response.responseJSON.errors);
                    if (response.responseJSON && response.responseJSON.errors) {
                        handleErrors(response.responseJSON.errors);
                    }
                }
            });
        });

        function handleErrors(errors) {
            $.each(errors, function(field, messages) {
                const errorElement = $(`#error-${field}`);
                errorElement.empty();

                if (errorElement.length) {
                    if(messages.length) {
                        //errorElement.show().text(message[0])
                        errorElement.show();
                        $.each(messages, function(index,message){
                            const errorMessage = $("<div>").text(message);
                                errorElement.append(errorMessage);
                        });
                    }

                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php /**PATH C:\OSPanel\domains\conceptechnology\resources\views/website/web-partials/contactform.blade.php ENDPATH**/ ?>