@extends('layouts.admin')
<title>{{ trans('home.edit_teams') }}</title>
@section('content')
    <div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.teams') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/teams') }}">{{ trans('home.teams') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_team') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.edit_team') }}</h6>
                        </div>
                        {!! Form::open([
                            'method' => 'PATCH',
                            'url' => 'admin/teams/' . $team->id,
                            'data-toggle' => 'validator',
                            'files' => 'true',
                        ]) !!}
                        <div class="row">
                             <div class="form-group col-md-3">
                                <label class="">{{ trans('home.name_en') }}</label>
                                <input class="form-control" name="name_en" type="text"
                                    placeholder="{{ trans('home.name_en') }}"  value="{{ $team->name_en }}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.name_ar') }}</label>
                                <input class="form-control" name="name_ar" type="text"
                                    placeholder="{{ trans('home.name_ar') }}"  value="{{ $team->name_ar }}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.order') }}</label>
                                <input class="form-control" name="order" type="number"
                                    placeholder="{{ trans('home.order') }}" value="{{$team->order}}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.link') }}</label>
                                <input class="form-control" name="link" type="text"
                                    placeholder="{{ trans('home.link') }}" value="{{ $team->link }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.email') }}</label>
                                <input class="form-control" name="email" type="text"
                                    placeholder="{{ trans('home.email') }}" value="{{ $team->email }}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.experience') }}</label>
                                <input class="form-control" name="experience" type="text"
                                    placeholder="{{ trans('home.experience') }}" value="{{ $team->experience }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.position_en') }}</label>
                                <input class="form-control" name="position_en" type="text"
                                    placeholder="{{ trans('home.position_en') }}" value="{{ $team->position_en }}">
                            </div>
                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.position_ar') }}</label>
                                <input class="form-control" name="position_ar" type="text"
                                    placeholder="{{ trans('home.position_ar') }}" value="{{ $team->position_ar }}">
                            </div>

                            <!--<div class="form-group col-md-3">-->
                            <!--    <label for="helperText">{{ trans('home.lang') }}</label>-->
                            <!--    <select class="form-control select2" name="lang" required>-->
                            <!--        <option value="en">{{ trans('home.english') }}</option>-->
                            <!--        <option value="ar">{{ trans('home.arabic') }}</option>-->
                            <!--    </select>-->
                            <!--</div>-->

                            <div class="form-group col-md-6">
                                <label class="">{{ trans('home.text_en') }}</label>
                                <input class="form-control" name="text_en" type="text"
                                    placeholder="{{ trans('home.text_en') }}" value="{{ $team->text_en }}">
                            </div>
                            
                            <div class="form-group col-md-6">
                                <label class="">{{ trans('home.text_ar') }}</label>
                                <input class="form-control" name="text_ar" type="text"
                                    placeholder="{{ trans('home.text_ar') }}" value="{{ $team->text_ar }}">
                            </div>


                            <div class="form-group  col-md-3">
                                <label>{{ trans('home.image') }}</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="img">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_image') }}</label>
                                    </div>
                                </div>
                            </div>


                            @if ($team->img)
                                <div class="form-group  col-md-12">
                                    <img src="{{ url('\uploads\teams\resize200') }}\{{ $team->img }}" width="200"
                                        height="150">
                                </div>
                            @endif

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.mobile') }}</label>
                                <input class="form-control" name="mobile" type="text"
                                    placeholder="{{ trans('home.mobile') }}" value="{{ $team->mobile }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.facebook') }}</label>
                                <input class="form-control" name="facebook" type="text"
                                    placeholder="{{ trans('home.facebook') }}" value="{{ $team->facebook }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.instagram') }}</label>
                                <input class="form-control" name="instgram" type="text"
                                    placeholder="{{ trans('home.instagram') }}" value="{{ $team->instgram }}">
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.linkedin') }}</label>
                                <input class="form-control" name="linkedin" type="text"
                                    placeholder="{{ trans('home.linkedin') }}" value="{{ $team->linkedin }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1" {{ $team->status == 1 ? 'checked' : '' }}
                                        type="checkbox"><span class="tx-13">{{ trans('home.publish') }}</span>
                                </label>
                            </div>

                            <div class="row">
                                <h6>Doctor's Schedule:</h6>
                                @foreach (['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'] as $day)
                                    @php
                                        $schedule = $schedules->firstWhere('day', $day);
                                    @endphp
                                    <div class="form-group col-md-6">
                                        <label class="">{{ ucfirst($day) }} Start Time</label>
                                        <input class="form-control" name="schedule[{{ $day }}][start]"
                                            type="time" placeholder="Start Time"
                                            value="{{ isset($schedule) ? $schedule->start_time : '' }}">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="">{{ ucfirst($day) }} End Time</label>
                                        <input class="form-control" name="schedule[{{ $day }}][end]"
                                            type="time" placeholder="End Time"
                                            value="{{ isset($schedule) ? $schedule->end_time : '' }}">
                                    </div>
                                @endforeach
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ trans('home.save') }} </button>
                                <a href="{{ url('/admin/teams') }}"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{ trans('home.cancel') }}</button></a>
                            </div>

                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
