@extends('layouts.app')
@section('BreadCrumb', $blog->{'title_' . $lang})
@section('BreadCrumb2', __('home.blog'))
@section('title')
    @php echo $metatags @endphp
@endsection
@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->
@section('breadtitle')
    <span class="sep"><i class="pbmit-base-icon-full-stop"></i></span>
    <span><a title="Blogs"
            href="{{ LaravelLocalization::localizeUrl('blogs') }}"><span>{{ __('home.blogs') }}</span></a></span>
@endsection
@include('website.web-partials.BreadCrumb')
@include('website.home-partials.slider')
<!-- <================================================================= BreadCrumb =======================================================> -->
<!--====== BLOG SECTION START ======-->
<section class="blog-section pt-120 pb-120">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="news-details-box">
                    <div class="entry-content">
                        <div class="post-gallery-slider mb-45">
                            <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}" alt="Image">

                        </div>
                        <h2 class="title">{{ $blog->{'title_' . $lang} }}</h2>
                        <ul class="post-meta">
                            <li><a href="#"><i class="fal fa-calendar-alt"></i>{{ $blog->date }}</a></li>
                        </ul>
                        <p class="mb-30">
                            {!! $blog->{'text_' . $lang} !!}
                        </p>
                        @include('website.web-partials.contact')
                        <div class="gap"></div>
                    </div>
                    <div class="entry-footer">
                        <div class="post-nav d-md-flex align-items-center justify-content-between">

                            <div class="prev-post">
                                @if ($prev_blog)
                                    <span>Prev Post</span>
                                    <a
                                        href="{{ LaravelLocalization::LocalizeUrl('blog/' . $prev_blog->{'link_' . $lang}) }}">
                                        <i class="fas fa-arrow-left"></i>
                                    </a>
                                @endif
                            </div>
                            <span class="icon">
                                <img src="{{ url('resources/assets/front/img/blog-details/icon.png') }}" alt="icon">
                            </span>

                            <div class="next-post text-end">
                                @if ($next_blog)
                                    <span>Next Post</span>
                                    <a
                                        href="{{ LaravelLocalization::LocalizeUrl('blog/' . $next_blog->{'link_' . $lang}) }}">
                                        <i class="fas fa-arrow-right"></i>
                                    </a>
                                @endif
                            </div>
                        </div>
                        <div class="related-post mt-50 blog-style-2">
                            <h3 class="mb-30">{{ __('home.related_blogs') }}</h3>
                            <div class="row">
                                @foreach ($blogs as $index => $blog)
                                    @if ($index < 2)
                                        <div class="col-md-6">
                                            <div class="blog-sing">
                                                <article class="blog-post"
                                                    style="background-image: url({{ Helper::uploadedImagesPath('blogitems', $blog->image) }});">
                                                    <div class="blog-data">
                                                        <div class="post-date">
                                                            {{$blog->date}}
                                                        </div>
                                                        <h3 class="post-title"><a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}">The Eyecare
                                                            {{ $blog->{'title_' . $lang} }}</a></h3>
                                                        <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}" class="post-link"><span>{{__('home.read_more')}}
                                                                </span></a>
                                                    </div>
                                                    <a href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}"></a>
                                                </article>
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Blog Sidebar -->
            <div class="col-lg-4 col-md-8 col-sm-10">
                <div class="sidebar sidebar-sticky">
                    <!-- Popular Post Widget -->
                    <div class="widget popular-feeds mb-40">
                        <h5 class="widget-title">{{ __('home.Popular') }}</h5>
                        <div class="popular-feed-loop">
                            @foreach ($blogs as $blog)
                                <div class="single-popular-feed">
                                    <div class="feed-img">
                                        <img src="{{ Helper::uploadedImagesPath('blogitems', $blog->image) }}"
                                            alt="Image">
                                    </div>
                                    <div class="feed-desc">
                                        <h6><a
                                                href="{{ LaravelLocalization::LocalizeUrl('blog/' . $blog->{'link_' . $lang}) }}">{{ $blog->{'title_' . $lang} }}</a>
                                        </h6>
                                        <span class="time"><i class="far fa-calendar-alt"></i>
                                            {{ $blog->date }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <!-- Social Icon Widget -->
                    <div class="widget socail-widget mb-40">
                        <h5 class="widget-title">{{ __('home.Never Miss News') }}</h5>
                        <ul>
                            @if ($setting->facebook)
                                <li> <a href="{{ $setting->facebook }}"><i class="fab fa-facebook-f"></i></a></li>
                            @endif
                            @if ($setting->twitter)
                                <li> <a href="{{ $setting->twitter }}"><i class="fab fa-twitter"></i></a></li>
                            @endif
                            @if ($setting->instgram)
                                <li> <a href="{{ $setting->instgram }}"><i class="fab fa-instagram"></i></a></li>
                            @endif
                            @if ($setting->linkedin)
                                <li> <a href="{{ $setting->linkedin }}"><i class="fab fa-linkedin"></i></a></li>
                            @endif
                            @if ($setting->youtube)
                                <li> <a href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a></li>
                            @endif
                        </ul>
                    </div>
                    <!-- Twitter Feeds Widget -->
                    <div class="widget twitter-feed-widget mb-40">
                        <h5 class="widget-title">{{ __('home.location') }}</h5>
                        <div class="twitter-looop">
                            <div class="map">
                                <iframe
                                    src="https://www.google.com/maps?q={{ urlencode($lastAddress->{'address_' . $lang}) }}&output=embed"
                                    width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                    referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--====== BLOG SECTION END ======-->
<!--====== BLOG SECTION END ======-->
<!-- Page Content End -->
@endsection
