@extends('layouts.app')
@section('title')
    @php echo $metatags @endphp
@endsection
@section('BreadCrumb', $service->{'name_' . $lang})
@section('BreadCrumb2', __('home.services'))
@section('seg', $service->{'link_' . $lang})
@section('content')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    @include('website.web-partials.BreadCrumb')
    @include('website.home-partials.slider')
    <!-- <================================================================= BreadCrumb =======================================================> -->
    <!-- Page Content -->
    <!--====== BLOG SECTION START ======-->
    <section class="blog-section pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center column-reverse">
                <div class="col-lg-8">
                    <div class="news-details-box">
                        <div class="entry-content features-loop">
                            <figure class="mt-15 mb-45">
                                <img src="{{ Helper::uploadedImagesPath('services', $service->img) }}" alt="Image">
                            </figure>
                            <div class="feature-box mb-30 mt-0 wow fadeInLeft" data-wow-delay=".3s">
                                <div class="icon"> <i class="flaticon-real-estate"></i>
                                </div>
                                <h3>{{ $service->{'name_' . $lang} }}</h3>
                                <!--<span class="count">{{ $service->order }}</span>-->
                            </div>
                            <p class="mb-30">
                                {!! $service->{'text_' . $lang} !!}
                            </p>
                            <div class="gap"></div>
                        </div>
                        <div class="comment-template">
                            <h3 class="box-title">Connect Us</h3>
                                @include('website.web-partials.contact')
                        </div>
                    </div>
                </div>
                <!-- Blog Sidebar -->
                <div class="col-lg-4">
                    <div class="sidebar">
                        <!-- Popular Post Widget -->
                        <div class="widget popular-feeds mb-40">
                            <h5 class="widget-title">{{__('home.related services')}}</h5>
                            <div class="popular-feed-loop">
                                @foreach ($rel_services as $index=>$rel_service)
                                    <div class="single-popular-feed">
                                        <div class="feed-img">
                                            <img src="{{ Helper::uploadedImagesPath('services', $rel_service->img) }}"
                                                alt="Image">
                                        </div>
                                        <div class="feed-desc">
                                            <h6><a
                                                    href="{{ LaravelLocalization::localizeUrl('service/' . $rel_service->{'link_' . $lang}) }}">{{ $rel_service->{'name_' . $lang} }}</a>
                                            </h6>
                                            <!--<span class="time"><i class="far fa-calendar-alt"></i>-->
                                            <!--    {{ $rel_service->created_at->format('jS F Y') }}</span>-->
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                        <!-- Twitter Feeds Widget -->
                        <div class="widget twitter-feed-widget mb-40">
                            <h5 class="widget-title">{{ __('home.location') }}</h5>
                            <div class="twitter-looop">
                                <div class="map">
                                    <iframe
                                        src="https://www.google.com/maps?q={{ urlencode($lastAddress->{'address_' . $lang}) }}&output=embed"
                                        width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"
                                        referrerpolicy="no-referrer-when-downgrade"></iframe>
                                </div>
                            </div>
                        </div>
                        <!-- Social Icon Widget -->
                        <div class="widget socail-widget mb-40">
                            <h5 class="widget-title">{{ __('home.Never Miss News') }}</h5>
                            <ul>
                                @if ($setting->facebook)
                                    <li> <a href="{{ $setting->facebook }}"><i class="fab fa-facebook-f"></i></a></li>
                                @endif
                                @if ($setting->twitter)
                                    <li> <a href="{{ $setting->twitter }}"><i class="fab fa-twitter"></i></a></li>
                                @endif
                                @if ($setting->instgram)
                                    <li> <a href="{{ $setting->instgram }}"><i class="fab fa-instagram"></i></a></li>
                                @endif
                                @if ($setting->linkedin)
                                    <li> <a href="{{ $setting->linkedin }}"><i class="fab fa-linkedin"></i></a></li>
                                @endif
                                @if ($setting->youtube)
                                    <li> <a href="{{ $setting->youtube }}"><i class="fab fa-youtube"></i></a></li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--====== BLOG SECTION END ======-->
@endsection
