<?php $__env->startSection('title'); ?>
    <title><?php echo e(trans('home.contact_us')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- page-title -->
<div class="page-header breadcrumb-wrap">
    <div class="container">
        <div class="breadcrumb">
            <a href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>" rel="nofollow">
                <i class="fi-rs-home mr-5"></i><?php echo e(__('home.home')); ?></a>
            <span></span> <?php echo e(__('home.contact-us')); ?>

        </div>
    </div>
</div>
<!-- page-title end -->


<div class="page-content pt-50">
    <div class="container">
        <?php if(session()->has('contact_message')): ?>
            <div class="alert alert-success d-flex justify-content-between">
                <?php echo e(session()->pull('contact_message')); ?>

                <a type="button" class="close"  aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </a>
            </div>
        <?php endif; ?>
        <?php if(session()->has('contact_message')): ?>
            <div class="alert alert-success d-flex justify-content-between">
                <?php echo e(session()->pull('contact_message')); ?>

                <a type="button" class="close" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </a>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="alert alert-danger">
                <ul class="list-unstyled">
                    <li class="d-flex justify-content-between">
                        <?php echo e($error); ?>

                        <a type="button" class="close" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </a>
                    </li>
                </ul>
            </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <div class="row">
            <div class="col-xl-10 col-lg-12 m-auto">
                <section class="row align-items-end mb-50">
                    <?php $__currentLoopData = $contact_messagges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$contact_messagge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($index==0): ?>
                            <div class="col-lg-4 mb-lg-0 mb-md-5 mb-sm-5">
                                <h4 class="mb-20 text-brand"><?php echo e(__('home.Need help? Call Us: ')); ?></h4>
                                <h1 class="mb-30"><?php echo e($contact_messagge->{'title_'.$lang}); ?></h1>
                                <p class="mb-20"><?php echo $contact_messagge->{'text_'.$lang}; ?></p>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-8">
                                <div class="row">
                    <?php $__currentLoopData = $contact_messagges; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index=>$contact_messagge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($index!=0): ?>
                                    <div class="col-lg-6 mb-4">
                                        <h5 class="mb-20"><?php echo e('0'.$index.'. '.$contact_messagge->{'title_'.$lang}); ?></h5>
                                        <p><?php echo $contact_messagge->{'text_'.$lang}; ?></p>
                                    </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                </section>
            </div>
        </div>
    </div>
    <section class="container mb-50 d-none d-md-block">
        <div class="border-radius-15 overflow-hidden">
            <iframe
                src="<?php echo e($setting->map_url); ?>" width="100%"
                height="600" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>
    </section>
    <div class="container">
        <div class="row">
            <div class="col-xl-10 col-lg-12 m-auto">
                <section class="mb-50">
                    <div class="row mb-60">
                        <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4 mb-4 mb-md-0">
                                <h4 class="mb-15 text-brand"><?php echo e($address->type=='Office'?__('home.Office'):($address->type=='Studio'?__('home.Studio'):__('home.Shop'))); ?></h4>
                                <div class="col-md-6 ">
                                    <b><?php echo e($address->{'address_'.$lang}); ?></b>
                                </div>
                            <abbr title="Phone"><?php echo e(__('home.phone')); ?>:</abbr>+2<?php echo e(' '.$address->tel); ?><br />
                            <abbr title="Email"><?php echo e(__('home.email')); ?>: </abbr>
                                <a href="/cdn-cgi/l/email-protection"
                                   class="__cf_email__" data-cfemail="ccafa3a2b8adafb88c89baadbeade2afa3a1"><?php echo e($address->email); ?></a><br />
                            <a href="<?php echo e(url($address->map_url)); ?>" class="btn btn-sm font-weight-bold text-white mt-20 border-radius-5 btn-shadow-brand hover-up"><i
                                    class="fi-rs-marker mr-5"></i><?php echo e(__('home.map_url')); ?></a>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="row">
                        <div class="col-xl-8">
                            <div class="contact-from-area padding-20-row-col">
                                <h5 class="text-brand mb-10"><?php echo e(__('home.Contact Information')); ?></h5>
                                <h2 class="mb-10"><?php echo e(__('home.Drop Us a Line')); ?></h2>
                                <form method="post" action="<?php echo e(url('save/contact-us')); ?>"
                                      id="contact-form" class="contact-form-style mt-30" >
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6">
                                            <div class="input-style mb-20">
                                                <input type="text" name="name" placeholder="<?php echo e(__('home.name')); ?>" required="" aria-required="true">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="input-style mb-20">
                                                <input type="email" name="email" placeholder="<?php echo e(__('home.email')); ?>" required="" aria-required="true">
                                            </div>
                                        </div>
                                        <div class="col-lg-6 col-md-6">
                                            <div class="input-style mb-20">
                                                <input type="text" name="phone"  placeholder="<?php echo e(__('home.phone')); ?>" aria-required="true" required>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 col-md-12">
                                            <div class="textarea-style mb-30">
                                                <textarea name="message" placeholder="<?php echo e(__('home.message')); ?>"></textarea>
                                            </div>
                                            <button class="submit submit-auto-width" type="submit"><?php echo e(__('home.send_message')); ?></button>
                                        </div>
                                    </div>
                                </form>
                                <p class="form-messege"></p>
                            </div>
                        </div>
                        <div class="col-lg-4 pl-50 d-lg-block d-none">
                            <img class="border-radius-15 mt-50"
                                 src="<?php echo e(Helper::uploadedImagesPath('settings/',$setting->contact_image)); ?>" alt="contact us" />
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>


























































































<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest/public_html/almashreq/resources/views/website/contact-us.blade.php ENDPATH**/ ?>